// File: test_lfsr24.v
// Generated by MyHDL 0.8.1
// Date: Fri Apr 11 14:53:52 2014


`timescale 1ns/10ps

module test_lfsr24 (

);



reg reset;
reg [23:0] lfsr;
reg enable;
reg clock;





always @(posedge clock, posedge reset) begin: TEST_LFSR24_DUT_LOGIC
    if ((reset == 1)) begin
        lfsr <= 1;
    end
    else begin
        if (enable) begin
            lfsr <= (lfsr << 1);
            lfsr[0] <= (((lfsr[23] ^ lfsr[22]) ^ lfsr[21]) ^ lfsr[16]);
        end
    end
end


initial begin: TEST_LFSR24_STIMULUS
    integer i;
    enable <= 0;
    clock <= 0;
    reset <= 0;
    # 10;
    reset <= 1;
    # 10;
    reset <= 0;
    enable <= 1;
    for (i=0; i<((2 ** 24) - 2); i=i+1) begin
        # 10;
        clock <= 1;
        # 10;
        clock <= 0;
        if ((lfsr != 1) !== 1) begin
            $display("*** AssertionError ***");
        end
    end
    # 10;
    clock <= 1;
    # 10;
    if ((lfsr == 1) !== 1) begin
        $display("*** AssertionError ***");
    end
end

endmodule
