-- File: test_lfsr24.vhd
-- Generated by MyHDL 0.8.1
-- Date: Fri Apr 11 14:53:52 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_081.all;

entity test_lfsr24 is
end entity test_lfsr24;


architecture MyHDL of test_lfsr24 is





signal reset: std_logic;
signal lfsr: unsigned(23 downto 0);
signal enable: std_logic;
signal clock: std_logic;

begin




TEST_LFSR24_DUT_LOGIC: process (clock, reset) is
begin
    if (reset = '1') then
        lfsr <= to_unsigned(1, 24);
    elsif rising_edge(clock) then
        if bool(enable) then
            lfsr <= shift_left(lfsr, 1);
            lfsr(0) <= (((lfsr(23) xor lfsr(22)) xor lfsr(21)) xor lfsr(16));
        end if;
    end if;
end process TEST_LFSR24_DUT_LOGIC;


TEST_LFSR24_STIMULUS: process is
begin
    enable <= '0';
    clock <= '0';
    reset <= '0';
    wait for 10 ns;
    reset <= '1';
    wait for 10 ns;
    reset <= '0';
    enable <= '1';
    for i in 0 to ((2 ** 24) - 2)-1 loop
        wait for 10 ns;
        clock <= '1';
        wait for 10 ns;
        clock <= '0';
        assert (lfsr /= 1)
            report "*** AssertionError ***"
            severity error;
    end loop;
    wait for 10 ns;
    clock <= '1';
    wait for 10 ns;
    assert (lfsr = 1)
        report "*** AssertionError ***"
        severity error;
    wait;
end process TEST_LFSR24_STIMULUS;

end architecture MyHDL;
