// File: test_longdiv.v
// Generated by MyHDL 0.8.1
// Date: Fri Apr 11 14:53:52 2014


`timescale 1ns/10ps

module test_longdiv (

);



reg reset;
reg [15:0] divisor;
reg clock;
reg start;
reg stopped;
reg ready;
reg [37:0] dividend;
reg [21:0] quotient;




function [32-1:0] MYHDL34_glibc_random;
    input [32-1:0] seed;
    reg [64-1:0] random_word;
begin: MYHDL36_RETURN
    random_word = 64'h0;
    random_word = ((seed * 32'h41c64e6d) + 12345);
    MYHDL34_glibc_random = random_word[32-1:0];
    disable MYHDL36_RETURN;
end
endfunction

function [32-1:0] MYHDL35_glibc_random;
    input [32-1:0] seed;
    reg [64-1:0] random_word;
begin: MYHDL37_RETURN
    random_word = 64'h0;
    random_word = ((seed * 32'h41c64e6d) + 12345);
    MYHDL35_glibc_random = random_word[32-1:0];
    disable MYHDL37_RETURN;
end
endfunction


always @(posedge clock, posedge reset) begin: TEST_LONGDIV_DUT_PROC
    reg [5-1:0] count;
    reg [1-1:0] state;
    reg [17-1:0] div;
    reg [21-1:0] divbits;
    reg [22-1:0] quot;
    if ((reset == 1)) begin
        quotient <= 0;
        ready <= 0;
        state = 1'b0;
        div = 0;
        divbits = 0;
        quot = 0;
    end
    else begin
        case (state)
            1'b0: begin
                if (start) begin
                    state = 1'b1;
                    ready <= 0;
                    quot = 0;
                    div[(16 + 1)-1:0] = dividend[38-1:(22 - 1)];
                    divbits = dividend[(22 - 1)-1:0];
                    count = 0;
                end
            end
            1'b1: begin
                quot[22-1:1] = quot[(22 - 1)-1:0];
                if ((div >= divisor)) begin
                    quot[0] = 1;
                    div = div - divisor;
                end
                else begin
                    quot[0] = 0;
                end
                if (($signed({1'b0, count}) == (22 - 1))) begin
                    ready <= 1;
                    state = 1'b0;
                end
                else begin
                    div[(16 + 1)-1:1] = div[16-1:0];
                    div[0] = divbits[(22 - 2)];
                    divbits[(22 - 1)-1:1] = divbits[(22 - 2)-1:0];
                    count = count + 1;
                end
            end
        endcase
    end
    quotient <= quot;
end


initial begin: TEST_LONGDIV_CLOCKGEN
    clock <= 0;
    # 10;
    while ((!stopped)) begin
        clock <= (!clock);
        # 10;
    end
end


initial begin: TEST_LONGDIV_STIMULUS
    reg [22-1:0] q;
    reg [16-1:0] p;
    reg [32-1:0] random_word;
    reg [38-1:0] d;
    integer i;
    stopped <= 0;
    # 10;
    random_word = 32'h0;
    p = 16'h0;
    q = 22'h0;
    d = 38'h0;
    @(negedge clock);
    reset <= 0;
    @(negedge clock);
    reset <= 1;
    @(negedge clock);
    reset <= 0;
    start <= 0;
    @(negedge clock);
    random_word = 94;
    for (i=0; i<262144; i=i+1) begin
        @(negedge clock);
        random_word = MYHDL34_glibc_random(random_word);
        p = random_word[16-1:0];
        random_word = MYHDL35_glibc_random(random_word);
        q = random_word[22-1:0];
        if ((p == 0)) begin
            q = 4194303;
        end
        d = (p * q);
        dividend <= d;
        divisor <= p;
        start <= 1;
        @(negedge clock);
        start <= 0;
        @(posedge ready);
        // compensate for Verilog's non-determinism
        # 1;
        if ((quotient == q) !== 1) begin
            $display("*** AssertionError ***");
        end
    end
    stopped <= 1;
    # 10;
end

endmodule
