-- File: test_longdiv.vhd
-- Generated by MyHDL 0.8.1
-- Date: Fri Apr 11 14:53:52 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_081.all;

entity test_longdiv is
end entity test_longdiv;


architecture MyHDL of test_longdiv is


constant Q: integer := 22;
constant MAXVAL: integer := 2**22-1;
constant M: integer := 38;
constant nrvectors: integer := 2**18;
constant N: integer := 2**4;


type t_enum_st_1 is (
    WAIT_START,
    CALC
);

signal reset: std_logic;
signal divisor: unsigned(15 downto 0);
signal clock: std_logic;
signal start: std_logic;
signal stopped: std_logic;
signal ready: std_logic;
signal dividend: unsigned(37 downto 0);
signal quotient: unsigned(21 downto 0);

function MYHDL47_glibc_random(
    seed: in unsigned
    ) return unsigned is
    variable random_word: unsigned(63 downto 0);
begin
    random_word := unsigned'("0000000000000000000000000000000000000000000000000000000000000000");
    random_word := ((seed * 1103515245) + 12345);
    return random_word(32-1 downto 0);
end function MYHDL47_glibc_random;

function MYHDL48_glibc_random(
    seed: in unsigned
    ) return unsigned is
    variable random_word: unsigned(63 downto 0);
begin
    random_word := unsigned'("0000000000000000000000000000000000000000000000000000000000000000");
    random_word := ((seed * 1103515245) + 12345);
    return random_word(32-1 downto 0);
end function MYHDL48_glibc_random;

begin




TEST_LONGDIV_DUT_PROC: process (clock, reset) is
    variable count: unsigned(4 downto 0);
    variable state: t_enum_st_1;
    variable div: unsigned(16 downto 0);
    variable divbits: unsigned(20 downto 0);
    variable quot: unsigned(21 downto 0);
begin
    if (reset = '1') then
        quotient <= to_unsigned(0, 22);
        ready <= '0';
        state := WAIT_START;
        div := to_unsigned(0, 17);
        divbits := to_unsigned(0, 21);
        quot := to_unsigned(0, 22);
    elsif rising_edge(clock) then
        case state is
            when WAIT_START =>
                if bool(start) then
                    state := CALC;
                    ready <= '0';
                    quot := to_unsigned(0, 22);
                    div((N + 1)-1 downto 0) := dividend(M-1 downto (Q - 1));
                    divbits := dividend((Q - 1)-1 downto 0);
                    count := to_unsigned(0, 5);
                end if;
            when others => -- CALC
                quot(Q-1 downto 1) := quot((Q - 1)-1 downto 0);
                if (div >= divisor) then
                    quot(0) := '1';
                    div := (div - divisor);
                else
                    quot(0) := '0';
                end if;
                if (signed(resize(count, 6)) = (Q - 1)) then
                    ready <= '1';
                    state := WAIT_START;
                else
                    div((N + 1)-1 downto 1) := div(N-1 downto 0);
                    div(0) := divbits((Q - 2));
                    divbits((Q - 1)-1 downto 1) := divbits((Q - 2)-1 downto 0);
                    count := (count + 1);
                end if;
        end case;
    end if;
    quotient <= quot;
end process TEST_LONGDIV_DUT_PROC;


TEST_LONGDIV_CLOCKGEN: process is
begin
    clock <= '0';
    wait for 10 ns;
    while (not bool(stopped)) loop
        clock <= stdl((not bool(clock)));
        wait for 10 ns;
    end loop;
    wait;
end process TEST_LONGDIV_CLOCKGEN;


TEST_LONGDIV_STIMULUS: process is
    variable q: unsigned(21 downto 0);
    variable p: unsigned(15 downto 0);
    variable random_word: unsigned(31 downto 0);
    variable d: unsigned(37 downto 0);
begin
    stopped <= '0';
    wait for 10 ns;
    random_word := unsigned'("00000000000000000000000000000000");
    p := to_unsigned(0, 16);
    q := to_unsigned(0, 22);
    d := unsigned'("00000000000000000000000000000000000000");
    wait until falling_edge(clock);
    reset <= '0';
    wait until falling_edge(clock);
    reset <= '1';
    wait until falling_edge(clock);
    reset <= '0';
    start <= '0';
    wait until falling_edge(clock);
    random_word := to_unsigned(94, 32);
    for i in 0 to nrvectors-1 loop
        wait until falling_edge(clock);
        random_word := MYHDL47_glibc_random(random_word);
        p := random_word(16-1 downto 0);
        random_word := MYHDL48_glibc_random(random_word);
        q := random_word(22-1 downto 0);
        if (p = 0) then
            q := to_unsigned(MAXVAL, 22);
        end if;
        d := (p * q);
        dividend <= d;
        divisor <= p;
        start <= '1';
        wait until falling_edge(clock);
        start <= '0';
        wait until rising_edge(ready);
        -- compensate for Verilog's non-determinism
        wait for 1 ns;
        assert (quotient = q)
            report "*** AssertionError ***"
            severity error;
    end loop;
    stopped <= '1';
    wait for 10 ns;
    wait;
end process TEST_LONGDIV_STIMULUS;

end architecture MyHDL;
