// File: test_randgen.v
// Generated by MyHDL 0.8.1
// Date: Fri Apr 11 14:53:52 2014


`timescale 1ns/10ps

module test_randgen (

);



reg reset;
reg enable;
reg [30:0] random_word;
reg clock;





always @(posedge clock, posedge reset) begin: TEST_RANDGEN_DUT_LOGIC
    integer i;
    reg [64-1:0] lfsr;
    reg [31-1:0] word;
    integer tmp0;
    if ((reset == 1)) begin
        random_word <= 0;
        lfsr = 1;
    end
    else begin
        if (enable) begin
            for (i=0; i<31; i=i+1) begin
                word[i] = lfsr[63];
                tmp0 = (((lfsr[63] ^ lfsr[62]) ^ lfsr[60]) ^ lfsr[59]);
                lfsr = lfsr << 1;
                lfsr[0] = tmp0;
            end
            random_word <= word;
        end
    end
end


initial begin: TEST_RANDGEN_STIMULUS
    integer i;
    enable <= 0;
    clock <= 0;
    reset <= 0;
    # 10;
    reset <= 1;
    # 10;
    reset <= 0;
    enable <= 1;
    for (i=0; i<(2 ** 20); i=i+1) begin
        # 10;
        clock <= 1;
        # 10;
        clock <= 0;
        $write("%0d", random_word);
        $write("\n");
    end
end

endmodule
