-- File: test_timer.vhd
-- Generated by MyHDL 0.8.1
-- Date: Fri Apr 11 14:53:52 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_081.all;

entity test_timer is
end entity test_timer;


architecture MyHDL of test_timer is


constant MAXVAL: integer := 1234;



signal reset: std_logic;
signal flag: std_logic;
signal clock: std_logic;

begin




TEST_TIMER_DUT_LOGIC: process (clock, reset) is
    variable count: unsigned(10 downto 0);
begin
    if (reset = '1') then
        count := to_unsigned(0, 11);
    elsif rising_edge(clock) then
        flag <= '0';
        if (count = MAXVAL) then
            flag <= '1';
            count := to_unsigned(0, 11);
        else
            count := (count + 1);
        end if;
    end if;
end process TEST_TIMER_DUT_LOGIC;


TEST_TIMER_CLKGEN: process is
begin
    clock <= '0';
    reset <= '0';
    wait for 10 ns;
    reset <= '1';
    wait for 10 ns;
    reset <= '0';
    wait for 10 ns;
    for i in 0 to (2 ** 25)-1 loop
        clock <= stdl((not bool(clock)));
        wait for 10 ns;
    end loop;
    wait;
end process TEST_TIMER_CLKGEN;


TEST_TIMER_MONITOR: process (clock) is
    variable count: unsigned(10 downto 0);
    variable seen: std_logic;
begin
    if rising_edge(clock) then
        if bool(seen) then
            if bool(flag) then
                assert (count = MAXVAL)
                    report "*** AssertionError ***"
                    severity error;
            else
                count := (count + 1);
            end if;
        end if;
        if bool(flag) then
            seen := '1';
            count := to_unsigned(0, 11);
        end if;
    end if;
end process TEST_TIMER_MONITOR;

end architecture MyHDL;
