-- File: bug_3577799.vhd
-- Generated by MyHDL 0.8.1
-- Date: Sun Aug 24 16:31:08 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_081.all;

entity bug_3577799 is
    port (
        clk: in std_logic;
        reset_clk: in std_logic;
        wr_data: in unsigned(15 downto 0);
        wr: in std_logic;
        rd_data: out unsigned(15 downto 0)
    );
end entity bug_3577799;


architecture MyHDL of bug_3577799 is


constant depth: integer := 8;




begin




BUG_3577799_SEQ: process (clk) is
    variable count: integer;
begin
    if rising_edge(clk) then
        if bool(reset_clk) then
            count := 0;
        else
            if bool(wr) then
                if (count < depth) then
                    rd_data <= wr_data;
                    count := (count + 1);
                end if;
            end if;
        end if;
    end if;
end process BUG_3577799_SEQ;

end architecture MyHDL;
