-- File: doIt.vhd
-- Generated by MyHDL 0.8
-- Date: Sun Aug 24 14:56:37 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_08.all;

entity doIt is
    port (
        reset: in std_logic;
        clk: in std_logic;
        d: in unsigned(31 downto 0);
        en: in std_logic;
        q: out unsigned(7 downto 0)
    );
end entity doIt;


architecture MyHDL of doIt is


constant COSET: integer := 85;




function MYHDL7_calculateHec(
    header: in unsigned
    ) return integer is
    variable bit: std_logic;
    variable hec: unsigned(7 downto 0);
begin
    hec := to_unsigned(0, 8);
    for ii in 32-1 downto 0 loop
        bit := header(ii);
        hec(8-1 downto 0) := unsigned'(hec(7-1 downto 2) & ((bit xor hec(1)) xor hec(7)) & ((bit xor hec(0)) xor hec(7)) & (bit xor hec(7)));
    end loop;
    return (hec xor to_unsigned(COSET, 8));
end function MYHDL7_calculateHec;

begin




DOIT_LOGIC: process (clk) is
begin
    if rising_edge(clk) then
        if (reset = '1') then
            q <= to_unsigned(0, 8);
        else
            if bool(en) then
                q <= MYHDL7_calculateHec(d);
            end if;
        end if;
    end if;
end process DOIT_LOGIC;

end architecture MyHDL;
