-- File: gray_counter.vhd
-- Generated by MyHDL 0.8.1
-- Date: Sun Aug 24 16:31:10 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_081.all;

entity gray_counter is
    port (
        clk: in std_logic;
        reset: in std_logic;
        enable: in std_logic;
        gray_count: out unsigned(7 downto 0)
    );
end entity gray_counter;


architecture MyHDL of gray_counter is





signal no_ones_below: unsigned(9 downto 0);
signal q: unsigned(9 downto 0);
signal q_msb: std_logic;

begin




GRAY_COUNTER_COMB: process (q, no_ones_below) is
begin
    q_msb <= stdl(bool(q(8)) or bool(q(7)));
    no_ones_below(0) <= '1';
    for j in 1 to 10-1 loop
        no_ones_below(j) <= stdl(bool(no_ones_below((j - 1))) and (not bool(q((j - 1)))));
    end loop;
    gray_count(8-1 downto 0) <= q(9-1 downto 1);
end process GRAY_COUNTER_COMB;


GRAY_COUNTER_SEQ: process (clk, reset) is
begin
    if (reset = '0') then
        q <= to_unsigned(0, 10);
    elsif rising_edge(clk) then
        if bool(enable) then
            q(0) <= stdl((not bool(q(0))));
            for i in 1 to 9-1 loop
                q(i) <= (q(i) xor stdl(bool(q((i - 1))) and bool(no_ones_below((i - 1)))));
            end loop;
            q(8) <= (q(8) xor stdl(bool(q_msb) and bool(no_ones_below(7))));
        end if;
    end if;
end process GRAY_COUNTER_SEQ;

end architecture MyHDL;
