// File: issue_13.v
// Generated by MyHDL 0.8.1
// Date: Sun Aug 24 16:31:05 2014


`timescale 1ns/10ps

module issue_13 (
    reset,
    clk,
    d,
    en,
    q
);


input reset;
input clk;
input [31:0] d;
input en;
output [7:0] q;
reg [7:0] q;





function integer MYHDL38_calculateHec;
    input [32-1:0] header;
    integer ii;
    reg bit;
    reg [8-1:0] hec;
begin: MYHDL41_RETURN
    hec = 8'h0;
    for (ii=32-1; ii>=0; ii=ii-1) begin
        bit = header[ii];
        hec[8-1:0] = {hec[7-1:2], ((bit ^ hec[1]) ^ hec[7]), ((bit ^ hec[0]) ^ hec[7]), (bit ^ hec[7])};
    end
    MYHDL38_calculateHec = (hec ^ 85);
    disable MYHDL41_RETURN;
end
endfunction


always @(posedge clk) begin: ISSUE_13_LOGIC
    if (reset == 1) begin
        q <= 0;
    end
    else begin
        if (en) begin
            q <= MYHDL38_calculateHec(d);
        end
    end
end

endmodule
