-- File: issue_13.vhd
-- Generated by MyHDL 0.8.1
-- Date: Sun Aug 24 16:31:11 2014


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_081.all;

entity issue_13 is
    port (
        reset: in std_logic;
        clk: in std_logic;
        d: in unsigned(31 downto 0);
        en: in std_logic;
        q: out unsigned(7 downto 0)
    );
end entity issue_13;


architecture MyHDL of issue_13 is


constant COSET: integer := 85;




function MYHDL38_calculateHec(
    header: in unsigned
    ) return integer is
    variable bit: std_logic;
    variable hec: unsigned(7 downto 0);
begin
    hec := to_unsigned(0, 8);
    for ii in 32-1 downto 0 loop
        bit := header(ii);
        hec(8-1 downto 0) := unsigned'(hec(7-1 downto 2) & ((bit xor hec(1)) xor hec(7)) & ((bit xor hec(0)) xor hec(7)) & (bit xor hec(7)));
    end loop;
    return to_integer((hec xor to_unsigned(COSET, 8)));
end function MYHDL38_calculateHec;

begin




ISSUE_13_LOGIC: process (clk) is
begin
    if rising_edge(clk) then
        if (reset = '1') then
            q <= to_unsigned(0, 8);
        else
            if bool(en) then
                q <= to_unsigned(MYHDL38_calculateHec(d), 8);
            end if;
        end if;
    end if;
end process ISSUE_13_LOGIC;

end architecture MyHDL;
