// File: gray_counter.v
// Generated by MyHDL 0.9dev
// Date: Wed Oct 16 22:27:21 2013


`timescale 1ns/10ps

module gray_counter (
    clk,
    reset,
    enable,
    gray_count
);


input clk;
input reset;
input enable;
output [7:0] gray_count;
reg [7:0] gray_count;

reg [9:0] no_ones_below;
reg [9:0] q;
reg q_msb;





always @(q, no_ones_below) begin: GRAY_COUNTER_COMB
    integer j;
    q_msb <= (q[8] || q[7]);
    no_ones_below[0] <= 1;
    for (j=1; j<10; j=j+1) begin
        no_ones_below[j] <= (no_ones_below[(j - 1)] && (!q[(j - 1)]));
    end
    gray_count[8-1:0] <= q[9-1:1];
end


always @(posedge clk, negedge reset) begin: GRAY_COUNTER_SEQ
    integer i;
    if (reset == 0) begin
        q <= 0;
    end
    else begin
        if (enable) begin
            q[0] <= (!q[0]);
            for (i=1; i<9; i=i+1) begin
                q[i] <= (q[i] ^ (q[(i - 1)] && no_ones_below[(i - 1)]));
            end
            q[8] <= (q[8] ^ (q_msb && no_ones_below[7]));
        end
    end
end

endmodule
