// File: pcie_legacyint_next_state_logic.v
// Generated by MyHDL 0.9dev
// Date: Wed Oct 16 22:27:15 2013


`timescale 1ns/10ps

module pcie_legacyint_next_state_logic (
    state_i,
    next_state_o,
    next_state_en_o,
    interrupt_pending_i,
    interrupt_assert_o
);


input [1:0] state_i;
output [1:0] next_state_o;
reg [1:0] next_state_o;
output next_state_en_o;
reg next_state_en_o;
input interrupt_pending_i;
output interrupt_assert_o;
reg interrupt_assert_o;






always @(state_i, interrupt_pending_i) begin: PCIE_LEGACYINT_NEXT_STATE_LOGIC_SM_OUTPUT
    casez (state_i)
        2'b?1: begin
            interrupt_assert_o = 0;
            next_state_en_o = interrupt_pending_i;
            next_state_o = 2'b10;
        end
        2'b1?: begin
            interrupt_assert_o = 1;
            next_state_en_o = (!interrupt_pending_i);
            next_state_o = 2'b01;
        end
        default: begin
            interrupt_assert_o = 0;
            next_state_en_o = 1;
            next_state_o = 2'b01;
        end
    endcase
end

endmodule
