-- File: pcie_legacyint_next_state_logic.vhd
-- Generated by MyHDL 0.9dev
-- Date: Wed Oct 16 22:27:21 2013



package pck_pcie_legacyint_next_state_logic is

attribute enum_encoding: string;

    type t_enum_t_state_1 is (
    WAIT_POSEDGE,
    WAIT_NEGEDGE
);
attribute enum_encoding of t_enum_t_state_1: type is "01 10";

end package pck_pcie_legacyint_next_state_logic;

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_09.all;

use work.pck_pcie_legacyint_next_state_logic.all;

entity pcie_legacyint_next_state_logic is
    port (
        state_i: in t_enum_t_state_1;
        next_state_o: out t_enum_t_state_1;
        next_state_en_o: out std_logic;
        interrupt_pending_i: in std_logic;
        interrupt_assert_o: out std_logic
    );
end entity pcie_legacyint_next_state_logic;


architecture MyHDL of pcie_legacyint_next_state_logic is






begin




PCIE_LEGACYINT_NEXT_STATE_LOGIC_SM_OUTPUT: process (state_i, interrupt_pending_i) is
begin
    case state_i is
        when WAIT_POSEDGE =>
            interrupt_assert_o <= '0';
            next_state_en_o <= interrupt_pending_i;
            next_state_o <= WAIT_NEGEDGE;
        when WAIT_NEGEDGE =>
            interrupt_assert_o <= '1';
            next_state_en_o <= stdl((not bool(interrupt_pending_i)));
            next_state_o <= WAIT_POSEDGE;
        when others =>
            interrupt_assert_o <= '0';
            next_state_en_o <= '1';
            next_state_o <= WAIT_POSEDGE;
    end case;
end process PCIE_LEGACYINT_NEXT_STATE_LOGIC_SM_OUTPUT;

end architecture MyHDL;
