mykvm
=====

* mykvm is a small python script to create multiple kvm instances from the yaml configuration file. 
* mykvm is using some nice tools like virt-install, vmbuilder, qemu-img and ansible.

Installation
------------

* Install kvm, virt-install, vmbuilder and some packages for ansible. Ansible will be used to initialize kvm instances.

        $ sudo apt-get update
        $ sudo apt-get install kvm libvirt-bin virtinst	python-vm-builder python-dev python-pip

* If you don't have any ssh key, generate a new ssh key. This key will be used to ssh into the kvm instances.  

        $ ssh-keygen -t rsa

* Install mykvm with pip

        $ sudo pip install mykvm

* Now, mykvm is ready

		$ mykvm 
		Usage: mykvm command [<args>]

		Available subcommands:
		    init
		    up [<vm>]
		    halt
		    destroy
		    status

Usage
---------------

* Create a new directory

		$ mkdir grizzly
		$ cd grizzly

* Run init command. If there's no base image, vmbuilder will create a precise64.qcow2 base image.

		$ mykvm init
		initialize mykvm
		
		* create mykvm.yml
		* copy vmbuilder script
		* copy ansible files
		* build base image /home/cirros/.mykvm/base/precise64.qcow2
		+ rm -rf ubuntu-kvm
		+ SUDOERS_TMPL=/etc/vmbuilder/ubuntu/sudoers.tmpl
		+ grep -q -e ubuntu /etc/vmbuilder/ubuntu/sudoers.tmpl
		+ sudo sed -i '$a ubuntu ALL=(ALL) NOPASSWD:ALL\n#includedir /etc/sudoers.d' /etc/vmbuilder/ubuntu/sudoers.tmpl
		+ sudo vmbuilder kvm ubuntu --suite precise --arch amd64 --flavour virtual --ssh-user-key /home/cirros/.ssh/id_rsa.pub ...
		...
		
* Up command will start networks and kvm instances with configurations in mykvm.yml.

		$ mykvm up
		
* Check the status of kvm instances.

		$ mykvm status
		status
		
		 Id Name                 State
		----------------------------------
		  1 controller           running
		  2 netnode              running
		  3 compute1             running
		  4 compute2             running
		  
* You can use virsh to control kvm instances.

		$ sudo virsh list
		 Id Name                 State
		----------------------------------
		  1 controller           running
		  2 netnode              running
		  3 compute1             running
		  4 compute2             running
		  
* You can ssh into the kvm instances with hostname. /etc/resolv.conf is updated to use the dnsmasq of first network in mykvm.yml as a nameserver.

		$ ssh ubuntu@controller

* Destroy command will stop networks and destroy kvm instances.

		$ mykvm destroy 

Configuration
---------------

* mykvm.yml configuration file look like this. 
* You can define multiple networks and vm instances with multiple network interfaces. 
* You can create nested kvm instances with 'kvm_nested' option.

		$ cat mykvm.yml 
		---
		- networks:
		  - name: mgmt
		    external: true
		    autostart: true
		    ip: 10.0.10.1
		
		  - name: int
		    ip: 10.0.20.1
		
		  - name: ext
		    external: true
		    ip: 192.168.101.1
		
		- vms:
		  - name: controller 
		    vcpus: 1
		    ram: 2048 
		    template: precise64.qcow2
		    netdevs:
		    - network: mgmt
		      ip: 10.0.10.10
		    - network: ext
		      ip: 192.168.101.10
		
		  - name: netnode 
		    vcpus: 2
		    ram: 1024 
		    template: precise64.qcow2
		    netdevs:
		    - network: mgmt
		      ip: 10.0.10.11
		    - network: int
		      ip: 10.0.20.11
		    - network: ext
		      ip: 192.168.101.11 
		      
		  - name: compute1 
		    vcpus: 2
		    kvm_nested: True
		    ram: 2048 
		    template: precise64.qcow2
		    netdevs:
		    - network: mgmt
		      ip: 10.0.10.12
		    - network: int
		      ip: 10.0.20.12

* Nested KVM Hypervisor Support

		$ echo "options kvm-intel nested=1" | sudo tee /etc/modprobe.d/kvm-intel.conf
		$ sudo reboot
		$ cat /sys/module/kvm_intel/parameters/nested 
		Y

Issues
====================

* Only tested on Ubuntu 12.04 boxes with intel cpu.
* Sometimes the base image generated by vmbuilder is not bootable. In that case, delete ubuntu-kvm directory and the base image under ~/.mykvm/base and run again init command to recreate a base image. 
