# $Header: /home/cvs2/mysql/mysql/exceptions/__init__.py,v 1.3 2006/08/26 20:19:52 ehuss Exp $
# Copyright (c) 2006, Eric Huss
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# 3. Neither the name of Eric Huss nor the names of any contributors may be
#    used to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

"""All MySQL exceptions.

This package contains all exceptions for the MySQL library.  All exceptions
from the submodules are imported into the top-level of this package so you do
not need to import any of the specific submodules.

There is a base exception `Error` for all exceptions.

There is generally two types of exceptions.  The ones that derive from
`MySQL_Error` are the ones that have a MySQL error code and are probably
generated by MySQL itself.  The others do not derive from `MySQL_Error` and are
generated by this Python library (these can be found in the
`mysql.exceptions.internal` module).

All errors that MySQL can generate have been given their own exception object.
These are generally the error code from the C library converted to bumpy case
with a few underscores added here and there to make them slightly more
readable.

Note that the MySQL API is somewhat inconsistent in its naming convention.
Sometimes the error code ends with ``_ERROR`` and sometimes it doesn't.
Although I'm tempted to normalize the naming scheme, I figure it might make
issues more confusing.

A modest attempt has been made to include the potential exceptions that might
be risen by various methods throughout this Python library in the docstrings.
This is mainly based on the MySQL documentation.  However, it is very far from
complete. Particularly, errors that are risen from the server side (those found
in `mysql.exceptions.server`) are generally not addressed at all in the
docstrings.  This would be a monumental task to try to identify them all and
properly document them.  It also might create too much noise, because many of
the server-side errors are not ones you would normally bother to catch.
"""

__version__ = '$Revision: 1.3 $'

from mysql.exceptions.base import *
from mysql.exceptions.client import *
from mysql.exceptions.internal import *
from mysql.exceptions.server import *
from mysql.exceptions.map import raise_error
