# $Header: /home/cvs2/mysql/mysql/exceptions/map.pyx,v 1.6 2006/11/13 04:00:00 ehuss Exp $
# Copyright (c) 2006, Eric Huss
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# 3. Neither the name of Eric Huss nor the names of any contributors may be
#    used to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

"""Mapping of MySQL internal error codes to exception objects.

This module should not be needed by end-user code, it is mainly for the
internals of this library.
"""

__version__ = '$Revision: 1.6 $'

from mysql.exceptions import client
from mysql.exceptions import server
include "../mysql_cr.pxi"
include "../mysql_er.pxi"

_errno_map = {CR_UNKNOWN_ERROR: client.Unknown_Error,
              CR_SOCKET_CREATE_ERROR: client.Socket_Create_Error,
              CR_CONNECTION_ERROR: client.Connection_Error,
              CR_CONN_HOST_ERROR: client.Conn_Host_Error,
              CR_IPSOCK_ERROR: client.IP_Sock_Error,
              CR_UNKNOWN_HOST: client.Unknown_Host,
              CR_SERVER_GONE_ERROR: client.Server_Gone_Error,
              CR_VERSION_ERROR: client.Version_Error,
              CR_OUT_OF_MEMORY: client.Out_Of_Memory,
              CR_WRONG_HOST_INFO: client.Wrong_Host_Info,
              CR_LOCALHOST_CONNECTION: client.Localhost_Connection,
              CR_TCP_CONNECTION: client.TCP_Connection,
              CR_SERVER_HANDSHAKE_ERR: client.Server_Handshake_Err,
              CR_SERVER_LOST: client.Server_Lost,
              CR_COMMANDS_OUT_OF_SYNC: client.Commands_Out_Of_Sync,
              CR_NAMEDPIPE_CONNECTION: client.Named_Pipe_Connection,
              CR_NAMEDPIPEWAIT_ERROR: client.Named_Pipe_Wait_Error,
              CR_NAMEDPIPEOPEN_ERROR: client.Named_Pipe_Open_Error,
              CR_NAMEDPIPESETSTATE_ERROR: client.Named_Pipe_Set_State_Error,
              CR_CANT_READ_CHARSET: client.Cant_Read_Charset,
              CR_NET_PACKET_TOO_LARGE: client.Net_Packet_Too_Large,
              CR_EMBEDDED_CONNECTION: client.Embedded_Connection,
              CR_PROBE_SLAVE_STATUS: client.Probe_Slave_Status,
              CR_PROBE_SLAVE_HOSTS: client.Probe_Slave_Hosts,
              CR_PROBE_SLAVE_CONNECT: client.Probe_Slave_Connect,
              CR_PROBE_MASTER_CONNECT: client.Probe_Master_Connect,
              CR_SSL_CONNECTION_ERROR: client.Ssl_Connection_Error,
              CR_MALFORMED_PACKET: client.Malformed_Packet,
              CR_WRONG_LICENSE: client.Wrong_License,
              CR_NULL_POINTER: client.Null_Pointer,
              CR_NO_PREPARE_STMT: client.No_Prepare_Stmt,
              CR_PARAMS_NOT_BOUND: client.Params_Not_Bound,
              CR_DATA_TRUNCATED: client.Data_Truncated,
              CR_NO_PARAMETERS_EXISTS: client.No_Parameters_Exists,
              CR_INVALID_PARAMETER_NO: client.Invalid_Parameter_Number,
              CR_INVALID_BUFFER_USE: client.Invalid_Buffer_Use,
              CR_UNSUPPORTED_PARAM_TYPE: client.Unsupported_Param_Type,
              CR_SHARED_MEMORY_CONNECTION: client.Shared_Memory_Connection,
              CR_SHARED_MEMORY_CONNECT_REQUEST_ERROR: client.Shared_Memory_Connect_Request_Error,
              CR_SHARED_MEMORY_CONNECT_ANSWER_ERROR: client.Shared_Memory_Connect_Answer_Error,
              CR_SHARED_MEMORY_CONNECT_FILE_MAP_ERROR: client.Shared_Memory_Connect_File_Map_Error,
              CR_SHARED_MEMORY_CONNECT_MAP_ERROR: client.Shared_Memory_Connect_Map_Error,
              CR_SHARED_MEMORY_FILE_MAP_ERROR: client.Shared_Memory_File_Map_Error,
              CR_SHARED_MEMORY_MAP_ERROR: client.Shared_Memory_Map_Error,
              CR_SHARED_MEMORY_EVENT_ERROR: client.Shared_Memory_Event_Error,
              CR_SHARED_MEMORY_CONNECT_ABANDONED_ERROR: client.Shared_Memory_Connect_Abandoned_Error,
              CR_SHARED_MEMORY_CONNECT_SET_ERROR: client.Shared_Memory_Connect_Set_Error,
              CR_CONN_UNKNOW_PROTOCOL: client.Conn_Unknow_Protocol,
              CR_INVALID_CONN_HANDLE: client.Invalid_Conn_Handle,
              CR_SECURE_AUTH: client.Secure_Auth,
              CR_FETCH_CANCELED: client.Fetch_Canceled,
              CR_NO_DATA: client.No_Data,
              CR_NO_STMT_METADATA: client.No_Stmt_Metadata,
              CR_NO_RESULT_SET: client.No_Result_Set,
              CR_NOT_IMPLEMENTED: client.Not_Implemented,

              ER_HASHCHK: server.Hashchk,
              ER_NISAMCHK: server.Nisamchk,
              ER_NO: server.No,
              ER_YES: server.Yes,
              ER_CANT_CREATE_FILE: server.Cant_Create_File,
              ER_CANT_CREATE_TABLE: server.Cant_Create_Table,
              ER_CANT_CREATE_DB: server.Cant_Create_DB,
              ER_DB_CREATE_EXISTS: server.DB_Create_Exists,
              ER_DB_DROP_EXISTS: server.DB_Drop_Exists,
              ER_DB_DROP_DELETE: server.DB_Drop_Delete,
              ER_DB_DROP_RMDIR: server.DB_Drop_Rmdir,
              ER_CANT_DELETE_FILE: server.Cant_Delete_File,
              ER_CANT_FIND_SYSTEM_REC: server.Cant_Find_System_Rec,
              ER_CANT_GET_STAT: server.Cant_Get_Stat,
              ER_CANT_GET_WD: server.Cant_Get_Wd,
              ER_CANT_LOCK: server.Cant_Lock,
              ER_CANT_OPEN_FILE: server.Cant_Open_File,
              ER_FILE_NOT_FOUND: server.File_Not_Found,
              ER_CANT_READ_DIR: server.Cant_Read_Dir,
              ER_CANT_SET_WD: server.Cant_Set_Wd,
              ER_CHECKREAD: server.Checkread,
              ER_DISK_FULL: server.Disk_Full,
              ER_DUP_KEY: server.Dup_Key,
              ER_ERROR_ON_CLOSE: server.Error_On_Close,
              ER_ERROR_ON_READ: server.Error_On_Read,
              ER_ERROR_ON_RENAME: server.Error_On_Rename,
              ER_ERROR_ON_WRITE: server.Error_On_Write,
              ER_FILE_USED: server.File_Used,
              ER_FILSORT_ABORT: server.Filsort_Abort,
              ER_FORM_NOT_FOUND: server.Form_Not_Found,
              ER_GET_ERRNO: server.Get_Errno,
              ER_ILLEGAL_HA: server.Illegal_Ha,
              ER_KEY_NOT_FOUND: server.Key_Not_Found,
              ER_NOT_FORM_FILE: server.Not_Form_File,
              ER_NOT_KEYFILE: server.Not_Keyfile,
              ER_OLD_KEYFILE: server.Old_Keyfile,
              ER_OPEN_AS_READONLY: server.Open_As_Readonly,
              ER_OUTOFMEMORY: server.Outofmemory,
              ER_OUT_OF_SORTMEMORY: server.Out_Of_Sortmemory,
              ER_UNEXPECTED_EOF: server.Unexpected_Eof,
              ER_CON_COUNT_ERROR: server.Con_Count_Error,
              ER_OUT_OF_RESOURCES: server.Out_Of_Resources,
              ER_BAD_HOST_ERROR: server.Bad_Host_Error,
              ER_HANDSHAKE_ERROR: server.Handshake_Error,
              ER_DBACCESS_DENIED_ERROR: server.DB_Access_Denied_Error,
              ER_ACCESS_DENIED_ERROR: server.Access_Denied_Error,
              ER_NO_DB_ERROR: server.No_DB_Error,
              ER_UNKNOWN_COM_ERROR: server.Unknown_Com_Error,
              ER_BAD_NULL_ERROR: server.Bad_Null_Error,
              ER_BAD_DB_ERROR: server.Bad_DB_Error,
              ER_TABLE_EXISTS_ERROR: server.Table_Exists_Error,
              ER_BAD_TABLE_ERROR: server.Bad_Table_Error,
              ER_NON_UNIQ_ERROR: server.Non_Uniq_Error,
              ER_SERVER_SHUTDOWN: server.Server_Shutdown,
              ER_BAD_FIELD_ERROR: server.Bad_Field_Error,
              ER_WRONG_FIELD_WITH_GROUP: server.Wrong_Field_With_Group,
              ER_WRONG_GROUP_FIELD: server.Wrong_Group_Field,
              ER_WRONG_SUM_SELECT: server.Wrong_Sum_Select,
              ER_WRONG_VALUE_COUNT: server.Wrong_Value_Count,
              ER_TOO_LONG_IDENT: server.Too_Long_Ident,
              ER_DUP_FIELDNAME: server.Dup_Fieldname,
              ER_DUP_KEYNAME: server.Dup_Keyname,
              ER_DUP_ENTRY: server.Dup_Entry,
              ER_WRONG_FIELD_SPEC: server.Wrong_Field_Spec,
              ER_PARSE_ERROR: server.Parse_Error,
              ER_EMPTY_QUERY: server.Empty_Query,
              ER_NONUNIQ_TABLE: server.Nonuniq_Table,
              ER_INVALID_DEFAULT: server.Invalid_Default,
              ER_MULTIPLE_PRI_KEY: server.Multiple_Pri_Key,
              ER_TOO_MANY_KEYS: server.Too_Many_Keys,
              ER_TOO_MANY_KEY_PARTS: server.Too_Many_Key_Parts,
              ER_TOO_LONG_KEY: server.Too_Long_Key,
              ER_KEY_COLUMN_DOES_NOT_EXITS: server.Key_Column_Does_Not_Exits,
              ER_BLOB_USED_AS_KEY: server.Blob_Used_As_Key,
              ER_TOO_BIG_FIELDLENGTH: server.Too_Big_Fieldlength,
              ER_WRONG_AUTO_KEY: server.Wrong_Auto_Key,
              ER_READY: server.Ready,
              ER_NORMAL_SHUTDOWN: server.Normal_Shutdown,
              ER_GOT_SIGNAL: server.Got_Signal,
              ER_SHUTDOWN_COMPLETE: server.Shutdown_Complete,
              ER_FORCING_CLOSE: server.Forcing_Close,
              ER_IPSOCK_ERROR: server.Ipsock_Error,
              ER_NO_SUCH_INDEX: server.No_Such_Index,
              ER_WRONG_FIELD_TERMINATORS: server.Wrong_Field_Terminators,
              ER_BLOBS_AND_NO_TERMINATED: server.Blobs_And_No_Terminated,
              ER_TEXTFILE_NOT_READABLE: server.Textfile_Not_Readable,
              ER_FILE_EXISTS_ERROR: server.File_Exists_Error,
              ER_LOAD_INFO: server.Load_Info,
              ER_ALTER_INFO: server.Alter_Info,
              ER_WRONG_SUB_KEY: server.Wrong_Sub_Key,
              ER_CANT_REMOVE_ALL_FIELDS: server.Cant_Remove_All_Fields,
              ER_CANT_DROP_FIELD_OR_KEY: server.Cant_Drop_Field_Or_Key,
              ER_INSERT_INFO: server.Insert_Info,
              ER_UPDATE_TABLE_USED: server.Update_Table_Used,
              ER_NO_SUCH_THREAD: server.No_Such_Thread,
              ER_KILL_DENIED_ERROR: server.Kill_Denied_Error,
              ER_NO_TABLES_USED: server.No_Tables_Used,
              ER_TOO_BIG_SET: server.Too_Big_Set,
              ER_NO_UNIQUE_LOGFILE: server.No_Unique_Logfile,
              ER_TABLE_NOT_LOCKED_FOR_WRITE: server.Table_Not_Locked_For_Write,
              ER_TABLE_NOT_LOCKED: server.Table_Not_Locked,
              ER_BLOB_CANT_HAVE_DEFAULT: server.Blob_Cant_Have_Default,
              ER_WRONG_DB_NAME: server.Wrong_DB_Name,
              ER_WRONG_TABLE_NAME: server.Wrong_Table_Name,
              ER_TOO_BIG_SELECT: server.Too_Big_Select,
              ER_UNKNOWN_ERROR: server.Unknown_Error,
              ER_UNKNOWN_PROCEDURE: server.Unknown_Procedure,
              ER_WRONG_PARAMCOUNT_TO_PROCEDURE: server.Wrong_Paramcount_To_Procedure,
              ER_WRONG_PARAMETERS_TO_PROCEDURE: server.Wrong_Parameters_To_Procedure,
              ER_UNKNOWN_TABLE: server.Unknown_Table,
              ER_FIELD_SPECIFIED_TWICE: server.Field_Specified_Twice,
              ER_INVALID_GROUP_FUNC_USE: server.Invalid_Group_Func_Use,
              ER_UNSUPPORTED_EXTENSION: server.Unsupported_Extension,
              ER_TABLE_MUST_HAVE_COLUMNS: server.Table_Must_Have_Columns,
              ER_RECORD_FILE_FULL: server.Record_File_Full,
              ER_UNKNOWN_CHARACTER_SET: server.Unknown_Character_Set,
              ER_TOO_MANY_TABLES: server.Too_Many_Tables,
              ER_TOO_MANY_FIELDS: server.Too_Many_Fields,
              ER_TOO_BIG_ROWSIZE: server.Too_Big_Rowsize,
              ER_STACK_OVERRUN: server.Stack_Overrun,
              ER_WRONG_OUTER_JOIN: server.Wrong_Outer_Join,
              ER_NULL_COLUMN_IN_INDEX: server.Null_Column_In_Index,
              ER_CANT_FIND_UDF: server.Cant_Find_Udf,
              ER_CANT_INITIALIZE_UDF: server.Cant_Initialize_Udf,
              ER_UDF_NO_PATHS: server.Udf_No_Paths,
              ER_UDF_EXISTS: server.Udf_Exists,
              ER_CANT_OPEN_LIBRARY: server.Cant_Open_Library,
              ER_CANT_FIND_DL_ENTRY: server.Cant_Find_Dl_Entry,
              ER_FUNCTION_NOT_DEFINED: server.Function_Not_Defined,
              ER_HOST_IS_BLOCKED: server.Host_Is_Blocked,
              ER_HOST_NOT_PRIVILEGED: server.Host_Not_Privileged,
              ER_PASSWORD_ANONYMOUS_USER: server.Password_Anonymous_User,
              ER_PASSWORD_NOT_ALLOWED: server.Password_Not_Allowed,
              ER_PASSWORD_NO_MATCH: server.Password_No_Match,
              ER_UPDATE_INFO: server.Update_Info,
              ER_CANT_CREATE_THREAD: server.Cant_Create_Thread,
              ER_WRONG_VALUE_COUNT_ON_ROW: server.Wrong_Value_Count_On_Row,
              ER_CANT_REOPEN_TABLE: server.Cant_Reopen_Table,
              ER_INVALID_USE_OF_NULL: server.Invalid_Use_Of_Null,
              ER_REGEXP_ERROR: server.Regexp_Error,
              ER_MIX_OF_GROUP_FUNC_AND_FIELDS: server.Mix_Of_Group_Func_And_Fields,
              ER_NONEXISTING_GRANT: server.Nonexisting_Grant,
              ER_TABLEACCESS_DENIED_ERROR: server.Tableaccess_Denied_Error,
              ER_COLUMNACCESS_DENIED_ERROR: server.Columnaccess_Denied_Error,
              ER_ILLEGAL_GRANT_FOR_TABLE: server.Illegal_Grant_For_Table,
              ER_GRANT_WRONG_HOST_OR_USER: server.Grant_Wrong_Host_Or_User,
              ER_NO_SUCH_TABLE: server.No_Such_Table,
              ER_NONEXISTING_TABLE_GRANT: server.Nonexisting_Table_Grant,
              ER_NOT_ALLOWED_COMMAND: server.Not_Allowed_Command,
              ER_SYNTAX_ERROR: server.Syntax_Error,
              ER_DELAYED_CANT_CHANGE_LOCK: server.Delayed_Cant_Change_Lock,
              ER_TOO_MANY_DELAYED_THREADS: server.Too_Many_Delayed_Threads,
              ER_ABORTING_CONNECTION: server.Aborting_Connection,
              ER_NET_PACKET_TOO_LARGE: server.Net_Packet_Too_Large,
              ER_NET_READ_ERROR_FROM_PIPE: server.Net_Read_Error_From_Pipe,
              ER_NET_FCNTL_ERROR: server.Net_Fcntl_Error,
              ER_NET_PACKETS_OUT_OF_ORDER: server.Net_Packets_Out_Of_Order,
              ER_NET_UNCOMPRESS_ERROR: server.Net_Uncompress_Error,
              ER_NET_READ_ERROR: server.Net_Read_Error,
              ER_NET_READ_INTERRUPTED: server.Net_Read_Interrupted,
              ER_NET_ERROR_ON_WRITE: server.Net_Error_On_Write,
              ER_NET_WRITE_INTERRUPTED: server.Net_Write_Interrupted,
              ER_TOO_LONG_STRING: server.Too_Long_String,
              ER_TABLE_CANT_HANDLE_BLOB: server.Table_Cant_Handle_Blob,
              ER_TABLE_CANT_HANDLE_AUTO_INCREMENT: server.Table_Cant_Handle_Auto_Increment,
              ER_DELAYED_INSERT_TABLE_LOCKED: server.Delayed_Insert_Table_Locked,
              ER_WRONG_COLUMN_NAME: server.Wrong_Column_Name,
              ER_WRONG_KEY_COLUMN: server.Wrong_Key_Column,
              ER_WRONG_MRG_TABLE: server.Wrong_Mrg_Table,
              ER_DUP_UNIQUE: server.Dup_Unique,
              ER_BLOB_KEY_WITHOUT_LENGTH: server.Blob_Key_Without_Length,
              ER_PRIMARY_CANT_HAVE_NULL: server.Primary_Cant_Have_Null,
              ER_TOO_MANY_ROWS: server.Too_Many_Rows,
              ER_REQUIRES_PRIMARY_KEY: server.Requires_Primary_Key,
              ER_NO_RAID_COMPILED: server.No_Raid_Compiled,
              ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE: server.Update_Without_Key_In_Safe_Mode,
              ER_KEY_DOES_NOT_EXITS: server.Key_Does_Not_Exits,
              ER_CHECK_NO_SUCH_TABLE: server.Check_No_Such_Table,
              ER_CHECK_NOT_IMPLEMENTED: server.Check_Not_Implemented,
              ER_CANT_DO_THIS_DURING_AN_TRANSACTION: server.Cant_Do_This_During_An_Transaction,
              ER_ERROR_DURING_COMMIT: server.Error_During_Commit,
              ER_ERROR_DURING_ROLLBACK: server.Error_During_Rollback,
              ER_ERROR_DURING_FLUSH_LOGS: server.Error_During_Flush_Logs,
              ER_ERROR_DURING_CHECKPOINT: server.Error_During_Checkpoint,
              ER_NEW_ABORTING_CONNECTION: server.New_Aborting_Connection,
              ER_DUMP_NOT_IMPLEMENTED: server.Dump_Not_Implemented,
              ER_FLUSH_MASTER_BINLOG_CLOSED: server.Flush_Master_Binlog_Closed,
              ER_INDEX_REBUILD: server.Index_Rebuild,
              ER_MASTER: server.Master,
              ER_MASTER_NET_READ: server.Master_Net_Read,
              ER_MASTER_NET_WRITE: server.Master_Net_Write,
              ER_FT_MATCHING_KEY_NOT_FOUND: server.Ft_Matching_Key_Not_Found,
              ER_LOCK_OR_ACTIVE_TRANSACTION: server.Lock_Or_Active_Transaction,
              ER_UNKNOWN_SYSTEM_VARIABLE: server.Unknown_System_Variable,
              ER_CRASHED_ON_USAGE: server.Crashed_On_Usage,
              ER_CRASHED_ON_REPAIR: server.Crashed_On_Repair,
              ER_WARNING_NOT_COMPLETE_ROLLBACK: server.Warning_Not_Complete_Rollback,
              ER_TRANS_CACHE_FULL: server.Trans_Cache_Full,
              ER_SLAVE_MUST_STOP: server.Slave_Must_Stop,
              ER_SLAVE_NOT_RUNNING: server.Slave_Not_Running,
              ER_BAD_SLAVE: server.Bad_Slave,
              ER_MASTER_INFO: server.Master_Info,
              ER_SLAVE_THREAD: server.Slave_Thread,
              ER_TOO_MANY_USER_CONNECTIONS: server.Too_Many_User_Connections,
              ER_SET_CONSTANTS_ONLY: server.Set_Constants_Only,
              ER_LOCK_WAIT_TIMEOUT: server.Lock_Wait_Timeout,
              ER_LOCK_TABLE_FULL: server.Lock_Table_Full,
              ER_READ_ONLY_TRANSACTION: server.Read_Only_Transaction,
              ER_DROP_DB_WITH_READ_LOCK: server.Drop_DB_With_Read_Lock,
              ER_CREATE_DB_WITH_READ_LOCK: server.Create_DB_With_Read_Lock,
              ER_WRONG_ARGUMENTS: server.Wrong_Arguments,
              ER_NO_PERMISSION_TO_CREATE_USER: server.No_Permission_To_Create_User,
              ER_UNION_TABLES_IN_DIFFERENT_DIR: server.Union_Tables_In_Different_Dir,
              ER_LOCK_DEADLOCK: server.Lock_Deadlock,
              ER_TABLE_CANT_HANDLE_FT: server.Table_Cant_Handle_Ft,
              ER_CANNOT_ADD_FOREIGN: server.Cannot_Add_Foreign,
              ER_NO_REFERENCED_ROW: server.No_Referenced_Row,
              ER_ROW_IS_REFERENCED: server.Row_Is_Referenced,
              ER_CONNECT_TO_MASTER: server.Connect_To_Master,
              ER_QUERY_ON_MASTER: server.Query_On_Master,
              ER_ERROR_WHEN_EXECUTING_COMMAND: server.Error_When_Executing_Command,
              ER_WRONG_USAGE: server.Wrong_Usage,
              ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT: server.Wrong_Number_Of_Columns_In_Select,
              ER_CANT_UPDATE_WITH_READLOCK: server.Cant_Update_With_Readlock,
              ER_MIXING_NOT_ALLOWED: server.Mixing_Not_Allowed,
              ER_DUP_ARGUMENT: server.Dup_Argument,
              ER_USER_LIMIT_REACHED: server.User_Limit_Reached,
              ER_SPECIFIC_ACCESS_DENIED_ERROR: server.Specific_Access_Denied_Error,
              ER_LOCAL_VARIABLE: server.Local_Variable,
              ER_GLOBAL_VARIABLE: server.Global_Variable,
              ER_NO_DEFAULT: server.No_Default,
              ER_WRONG_VALUE_FOR_VAR: server.Wrong_Value_For_Var,
              ER_WRONG_TYPE_FOR_VAR: server.Wrong_Type_For_Var,
              ER_VAR_CANT_BE_READ: server.Var_Cant_Be_Read,
              ER_CANT_USE_OPTION_HERE: server.Cant_Use_Option_Here,
              ER_NOT_SUPPORTED_YET: server.Not_Supported_Yet,
              ER_MASTER_FATAL_ERROR_READING_BINLOG: server.Master_Fatal_Error_Reading_Binlog,
              ER_SLAVE_IGNORED_TABLE: server.Slave_Ignored_Table,
              ER_INCORRECT_GLOBAL_LOCAL_VAR: server.Incorrect_Global_Local_Var,
              ER_WRONG_FK_DEF: server.Wrong_Fk_Def,
              ER_KEY_REF_DO_NOT_MATCH_TABLE_REF: server.Key_Ref_Do_Not_Match_Table_Ref,
              ER_OPERAND_COLUMNS: server.Operand_Columns,
              ER_SUBQUERY_NO_1_ROW: server.Subquery_No_1_Row,
              ER_UNKNOWN_STMT_HANDLER: server.Unknown_Stmt_Handler,
              ER_CORRUPT_HELP_DB: server.Corrupt_Help_DB,
              ER_CYCLIC_REFERENCE: server.Cyclic_Reference,
              ER_AUTO_CONVERT: server.Auto_Convert,
              ER_ILLEGAL_REFERENCE: server.Illegal_Reference,
              ER_DERIVED_MUST_HAVE_ALIAS: server.Derived_Must_Have_Alias,
              ER_SELECT_REDUCED: server.Select_Reduced,
              ER_TABLENAME_NOT_ALLOWED_HERE: server.Tablename_Not_Allowed_Here,
              ER_NOT_SUPPORTED_AUTH_MODE: server.Not_Supported_Auth_Mode,
              ER_SPATIAL_CANT_HAVE_NULL: server.Spatial_Cant_Have_Null,
              ER_COLLATION_CHARSET_MISMATCH: server.Collation_Charset_Mismatch,
              ER_SLAVE_WAS_RUNNING: server.Slave_Was_Running,
              ER_SLAVE_WAS_NOT_RUNNING: server.Slave_Was_Not_Running,
              ER_TOO_BIG_FOR_UNCOMPRESS: server.Too_Big_For_Uncompress,
              ER_ZLIB_Z_MEM_ERROR: server.Zlib_Z_Mem_Error,
              ER_ZLIB_Z_BUF_ERROR: server.Zlib_Z_Buf_Error,
              ER_ZLIB_Z_DATA_ERROR: server.Zlib_Z_Data_Error,
              ER_CUT_VALUE_GROUP_CONCAT: server.Cut_Value_Group_Concat,
              ER_WARN_TOO_FEW_RECORDS: server.Warn_Too_Few_Records,
              ER_WARN_TOO_MANY_RECORDS: server.Warn_Too_Many_Records,
              ER_WARN_NULL_TO_NOTNULL: server.Warn_Null_To_Notnull,
              ER_WARN_DATA_OUT_OF_RANGE: server.Warn_Data_Out_Of_Range,
              WARN_DATA_TRUNCATED: server.Warn_Data_Truncated,
              ER_WARN_USING_OTHER_HANDLER: server.Warn_Using_Other_Handler,
              ER_CANT_AGGREGATE_2COLLATIONS: server.Cant_Aggregate_2Collations,
              ER_DROP_USER: server.Drop_User,
              ER_REVOKE_GRANTS: server.Revoke_Grants,
              ER_CANT_AGGREGATE_3COLLATIONS: server.Cant_Aggregate_3Collations,
              ER_CANT_AGGREGATE_NCOLLATIONS: server.Cant_Aggregate_Ncollations,
              ER_VARIABLE_IS_NOT_STRUCT: server.Variable_Is_Not_Struct,
              ER_UNKNOWN_COLLATION: server.Unknown_Collation,
              ER_SLAVE_IGNORED_SSL_PARAMS: server.Slave_Ignored_Ssl_Params,
              ER_SERVER_IS_IN_SECURE_AUTH_MODE: server.Server_Is_In_Secure_Auth_Mode,
              ER_WARN_FIELD_RESOLVED: server.Warn_Field_Resolved,
              ER_BAD_SLAVE_UNTIL_COND: server.Bad_Slave_Until_Cond,
              ER_MISSING_SKIP_SLAVE: server.Missing_Skip_Slave,
              ER_UNTIL_COND_IGNORED: server.Until_Cond_Ignored,
              ER_WRONG_NAME_FOR_INDEX: server.Wrong_Name_For_Index,
              ER_WRONG_NAME_FOR_CATALOG: server.Wrong_Name_For_Catalog,
              ER_WARN_QC_RESIZE: server.Warn_Qc_Resize,
              ER_BAD_FT_COLUMN: server.Bad_Ft_Column,
              ER_UNKNOWN_KEY_CACHE: server.Unknown_Key_Cache,
              ER_WARN_HOSTNAME_WONT_WORK: server.Warn_Hostname_Wont_Work,
              ER_UNKNOWN_STORAGE_ENGINE: server.Unknown_Storage_Engine,
              ER_WARN_DEPRECATED_SYNTAX: server.Warn_Deprecated_Syntax,
              ER_NON_UPDATABLE_TABLE: server.Non_Updatable_Table,
              ER_FEATURE_DISABLED: server.Feature_Disabled,
              ER_OPTION_PREVENTS_STATEMENT: server.Option_Prevents_Statement,
              ER_DUPLICATED_VALUE_IN_TYPE: server.Duplicated_Value_In_Type,
              ER_TRUNCATED_WRONG_VALUE: server.Truncated_Wrong_Value,
              ER_TOO_MUCH_AUTO_TIMESTAMP_COLS: server.Too_Much_Auto_Timestamp_Cols,
              ER_INVALID_ON_UPDATE: server.Invalid_On_Update,
              ER_UNSUPPORTED_PS: server.Unsupported_Ps,
              ER_GET_ERRMSG: server.Get_Errmsg,
              ER_GET_TEMPORARY_ERRMSG: server.Get_Temporary_Errmsg,
              ER_UNKNOWN_TIME_ZONE: server.Unknown_Time_Zone,
              ER_WARN_INVALID_TIMESTAMP: server.Warn_Invalid_Timestamp,
              ER_INVALID_CHARACTER_STRING: server.Invalid_Character_String,
              ER_WARN_ALLOWED_PACKET_OVERFLOWED: server.Warn_Allowed_Packet_Overflowed,
              ER_CONFLICTING_DECLARATIONS: server.Conflicting_Declarations,
              ER_SP_NO_RECURSIVE_CREATE: server.Sp_No_Recursive_Create,
              ER_SP_ALREADY_EXISTS: server.Sp_Already_Exists,
              ER_SP_DOES_NOT_EXIST: server.Sp_Does_Not_Exist,
              ER_SP_DROP_FAILED: server.Sp_Drop_Failed,
              ER_SP_STORE_FAILED: server.Sp_Store_Failed,
              ER_SP_LILABEL_MISMATCH: server.Sp_Lilabel_Mismatch,
              ER_SP_LABEL_REDEFINE: server.Sp_Label_Redefine,
              ER_SP_LABEL_MISMATCH: server.Sp_Label_Mismatch,
              ER_SP_UNINIT_VAR: server.Sp_Uninit_Var,
              ER_SP_BADSELECT: server.Sp_Badselect,
              ER_SP_BADRETURN: server.Sp_Badreturn,
              ER_SP_BADSTATEMENT: server.Sp_Badstatement,
              ER_UPDATE_LOG_DEPRECATED_IGNORED: server.Update_Log_Deprecated_Ignored,
              ER_UPDATE_LOG_DEPRECATED_TRANSLATED: server.Update_Log_Deprecated_Translated,
              ER_QUERY_INTERRUPTED: server.Query_Interrupted,
              ER_SP_WRONG_NO_OF_ARGS: server.Sp_Wrong_No_Of_Args,
              ER_SP_COND_MISMATCH: server.Sp_Cond_Mismatch,
              ER_SP_NORETURN: server.Sp_Noreturn,
              ER_SP_NORETURNEND: server.Sp_Noreturnend,
              ER_SP_BAD_CURSOR_QUERY: server.Sp_Bad_Cursor_Query,
              ER_SP_BAD_CURSOR_SELECT: server.Sp_Bad_Cursor_Select,
              ER_SP_CURSOR_MISMATCH: server.Sp_Cursor_Mismatch,
              ER_SP_CURSOR_ALREADY_OPEN: server.Sp_Cursor_Already_Open,
              ER_SP_CURSOR_NOT_OPEN: server.Sp_Cursor_Not_Open,
              ER_SP_UNDECLARED_VAR: server.Sp_Undeclared_Var,
              ER_SP_WRONG_NO_OF_FETCH_ARGS: server.Sp_Wrong_No_Of_Fetch_Args,
              ER_SP_FETCH_NO_DATA: server.Sp_Fetch_No_Data,
              ER_SP_DUP_PARAM: server.Sp_Dup_Param,
              ER_SP_DUP_VAR: server.Sp_Dup_Var,
              ER_SP_DUP_COND: server.Sp_Dup_Cond,
              ER_SP_DUP_CURS: server.Sp_Dup_Curs,
              ER_SP_CANT_ALTER: server.Sp_Cant_Alter,
              ER_SP_SUBSELECT_NYI: server.Sp_Subselect_Nyi,
              ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG: server.Stmt_Not_Allowed_In_Sf_Or_Trg,
              ER_SP_VARCOND_AFTER_CURSHNDLR: server.Sp_Varcond_After_Curshndlr,
              ER_SP_CURSOR_AFTER_HANDLER: server.Sp_Cursor_After_Handler,
              ER_SP_CASE_NOT_FOUND: server.Sp_Case_Not_Found,
              ER_FPARSER_TOO_BIG_FILE: server.Fparser_Too_Big_File,
              ER_FPARSER_BAD_HEADER: server.Fparser_Bad_Header,
              ER_FPARSER_EOF_IN_COMMENT: server.Fparser_Eof_In_Comment,
              ER_FPARSER_ERROR_IN_PARAMETER: server.Fparser_Error_In_Parameter,
              ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER: server.Fparser_Eof_In_Unknown_Parameter,
              ER_VIEW_NO_EXPLAIN: server.View_No_Explain,
              ER_FRM_UNKNOWN_TYPE: server.Frm_Unknown_Type,
              ER_WRONG_OBJECT: server.Wrong_Object,
              ER_NONUPDATEABLE_COLUMN: server.Nonupdateable_Column,
              ER_VIEW_SELECT_DERIVED: server.View_Select_Derived,
              ER_VIEW_SELECT_CLAUSE: server.View_Select_Clause,
              ER_VIEW_SELECT_VARIABLE: server.View_Select_Variable,
              ER_VIEW_SELECT_TMPTABLE: server.View_Select_Tmptable,
              ER_VIEW_WRONG_LIST: server.View_Wrong_List,
              ER_WARN_VIEW_MERGE: server.Warn_View_Merge,
              ER_WARN_VIEW_WITHOUT_KEY: server.Warn_View_Without_Key,
              ER_VIEW_INVALID: server.View_Invalid,
              ER_SP_NO_DROP_SP: server.Sp_No_Drop_Sp,
              ER_SP_GOTO_IN_HNDLR: server.Sp_Goto_In_Hndlr,
              ER_TRG_ALREADY_EXISTS: server.Trg_Already_Exists,
              ER_TRG_DOES_NOT_EXIST: server.Trg_Does_Not_Exist,
              ER_TRG_ON_VIEW_OR_TEMP_TABLE: server.Trg_On_View_Or_Temp_Table,
              ER_TRG_CANT_CHANGE_ROW: server.Trg_Cant_Change_Row,
              ER_TRG_NO_SUCH_ROW_IN_TRG: server.Trg_No_Such_Row_In_Trg,
              ER_NO_DEFAULT_FOR_FIELD: server.No_Default_For_Field,
              ER_DIVISION_BY_ZERO: server.Division_By_Zero,
              ER_TRUNCATED_WRONG_VALUE_FOR_FIELD: server.Truncated_Wrong_Value_For_Field,
              ER_ILLEGAL_VALUE_FOR_TYPE: server.Illegal_Value_For_Type,
              ER_VIEW_NONUPD_CHECK: server.View_Nonupd_Check,
              ER_VIEW_CHECK_FAILED: server.View_Check_Failed,
              ER_PROCACCESS_DENIED_ERROR: server.Procaccess_Denied_Error,
              ER_RELAY_LOG_FAIL: server.Relay_Log_Fail,
              ER_PASSWD_LENGTH: server.Passwd_Length,
              ER_UNKNOWN_TARGET_BINLOG: server.Unknown_Target_Binlog,
              ER_IO_ERR_LOG_INDEX_READ: server.Io_Err_Log_Index_Read,
              ER_BINLOG_PURGE_PROHIBITED: server.Binlog_Purge_Prohibited,
              ER_FSEEK_FAIL: server.Fseek_Fail,
              ER_BINLOG_PURGE_FATAL_ERR: server.Binlog_Purge_Fatal_Err,
              ER_LOG_IN_USE: server.Log_In_Use,
              ER_LOG_PURGE_UNKNOWN_ERR: server.Log_Purge_Unknown_Err,
              ER_RELAY_LOG_INIT: server.Relay_Log_Init,
              ER_NO_BINARY_LOGGING: server.No_Binary_Logging,
              ER_RESERVED_SYNTAX: server.Reserved_Syntax,
              ER_WSAS_FAILED: server.Wsas_Failed,
              ER_DIFF_GROUPS_PROC: server.Diff_Groups_Proc,
              ER_NO_GROUP_FOR_PROC: server.No_Group_For_Proc,
              ER_ORDER_WITH_PROC: server.Order_With_Proc,
              ER_LOGGING_PROHIBIT_CHANGING_OF: server.Logging_Prohibit_Changing_Of,
              ER_NO_FILE_MAPPING: server.No_File_Mapping,
              ER_WRONG_MAGIC: server.Wrong_Magic,
              ER_PS_MANY_PARAM: server.Ps_Many_Param,
              ER_KEY_PART_0: server.Key_Part_0,
              ER_VIEW_CHECKSUM: server.View_Checksum,
              ER_VIEW_MULTIUPDATE: server.View_Multiupdate,
              ER_VIEW_NO_INSERT_FIELD_LIST: server.View_No_Insert_Field_List,
              ER_VIEW_DELETE_MERGE_VIEW: server.View_Delete_Merge_View,
              ER_CANNOT_USER: server.Cannot_User,
              ER_XAER_NOTA: server.Xaer_Nota,
              ER_XAER_INVAL: server.Xaer_Inval,
              ER_XAER_RMFAIL: server.Xaer_Rmfail,
              ER_XAER_OUTSIDE: server.Xaer_Outside,
              ER_XAER_RMERR: server.Xaer_Rmerr,
              ER_XA_RBROLLBACK: server.Xa_Rbrollback,
              ER_NONEXISTING_PROC_GRANT: server.Nonexisting_Proc_Grant,
              ER_PROC_AUTO_GRANT_FAIL: server.Proc_Auto_Grant_Fail,
              ER_PROC_AUTO_REVOKE_FAIL: server.Proc_Auto_Revoke_Fail,
              ER_DATA_TOO_LONG: server.Data_Too_Long,
              ER_SP_BAD_SQLSTATE: server.Sp_Bad_Sqlstate,
              ER_STARTUP: server.Startup,
              ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR: server.Load_From_Fixed_Size_Rows_To_Var,
              ER_CANT_CREATE_USER_WITH_GRANT: server.Cant_Create_User_With_Grant,
              ER_WRONG_VALUE_FOR_TYPE: server.Wrong_Value_For_Type,
              ER_TABLE_DEF_CHANGED: server.Table_Def_Changed,
              ER_SP_DUP_HANDLER: server.Sp_Dup_Handler,
              ER_SP_NOT_VAR_ARG: server.Sp_Not_Var_Arg,
              ER_SP_NO_RETSET: server.Sp_No_Retset,
              ER_CANT_CREATE_GEOMETRY_OBJECT: server.Cant_Create_Geometry_Object,
              ER_FAILED_ROUTINE_BREAK_BINLOG: server.Failed_Routine_Break_Binlog,
              ER_BINLOG_UNSAFE_ROUTINE: server.Binlog_Unsafe_Routine,
              ER_BINLOG_CREATE_ROUTINE_NEED_SUPER: server.Binlog_Create_Routine_Need_Super,
              ER_EXEC_STMT_WITH_OPEN_CURSOR: server.Exec_Stmt_With_Open_Cursor,
              ER_STMT_HAS_NO_OPEN_CURSOR: server.Stmt_Has_No_Open_Cursor,
              ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG: server.Commit_Not_Allowed_In_Sf_Or_Trg,
              ER_NO_DEFAULT_FOR_VIEW_FIELD: server.No_Default_For_View_Field,
              ER_SP_NO_RECURSION: server.Sp_No_Recursion,
              ER_TOO_BIG_SCALE: server.Too_Big_Scale,
              ER_TOO_BIG_PRECISION: server.Too_Big_Precision,
              ER_M_BIGGER_THAN_D: server.M_Bigger_Than_D,
              ER_WRONG_LOCK_OF_SYSTEM_TABLE: server.Wrong_Lock_Of_System_Table,
              ER_CONNECT_TO_FOREIGN_DATA_SOURCE: server.Connect_To_Foreign_Data_Source,
              ER_QUERY_ON_FOREIGN_DATA_SOURCE: server.Query_On_Foreign_Data_Source,
              ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST: server.Foreign_Data_Source_Doesnt_Exist,
              ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE: server.Foreign_Data_String_Invalid_Cant_Create,
              ER_FOREIGN_DATA_STRING_INVALID: server.Foreign_Data_String_Invalid,
              ER_CANT_CREATE_FEDERATED_TABLE: server.Cant_Create_Federated_Table,
              ER_TRG_IN_WRONG_SCHEMA: server.Trg_In_Wrong_Schema,
              ER_STACK_OVERRUN_NEED_MORE: server.Stack_Overrun_Need_More,
              ER_TOO_LONG_BODY: server.Too_Long_Body,
              ER_WARN_CANT_DROP_DEFAULT_KEYCACHE: server.Warn_Cant_Drop_Default_Keycache,
              ER_TOO_BIG_DISPLAYWIDTH: server.Too_Big_Displaywidth,
              ER_XAER_DUPID: server.Xaer_Dupid,
              ER_DATETIME_FUNCTION_OVERFLOW: server.Datetime_Function_Overflow,
              ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG: server.Cant_Update_Used_Table_In_Sf_Or_Trg,
              ER_VIEW_PREVENT_UPDATE: server.View_Prevent_Update,
              ER_PS_NO_RECURSION: server.Ps_No_Recursion,
              ER_SP_CANT_SET_AUTOCOMMIT: server.Sp_Cant_Set_Autocommit,
              ER_VIEW_FRM_NO_USER: server.View_Frm_No_User,
              ER_VIEW_OTHER_USER: server.View_Other_User,
              ER_NO_SUCH_USER: server.No_Such_User,
              ER_FORBID_SCHEMA_CHANGE: server.Forbid_Schema_Change,
              ER_ROW_IS_REFERENCED_2: server.Row_Is_Referenced_2,
              ER_NO_REFERENCED_ROW_2: server.No_Referenced_Row_2,
              ER_SP_BAD_VAR_SHADOW: server.Sp_Bad_Var_Shadow,
             }

%if MYSQL_VERSION <= 5001690:
    _errno_map[ER_NO_VIEW_USER] = server.No_View_User

%if MYSQL_VERSION >= 5001790:
    _errno_map[ER_SP_RECURSION_LIMIT] = server.Sp_Recursion_Limit
    _errno_map[ER_MALFORMED_DEFINER] = server.Malformed_Definer
    _errno_map[ER_OLD_FILE_FORMAT] = server.Old_File_Format
    _errno_map[ER_TRG_NO_DEFINER] = server.Trg_No_Definer
    _errno_map[ER_SP_PROC_TABLE_CORRUPT] = server.Sp_Proc_Table_Corrupt

%if MYSQL_VERSION >= 5001990:
    _errno_map[ER_TABLE_NEEDS_UPGRADE] = server.Table_Needs_Upgrade
    _errno_map[ER_SP_NO_AGGREGATE] = server.Sp_No_Aggregate
    _errno_map[ER_SP_WRONG_NAME] = server.Sp_Wrong_Name

%if MYSQL_VERSION >= 5002190:
    _errno_map[ER_MAX_PREPARED_STMT_COUNT_REACHED] = server.Max_Prepared_Stmt_Count_Reached
    _errno_map[ER_VIEW_RECURSIVE] = server.View_Recursive

%if MYSQL_VERSION >= 5002390:
    _errno_map[ER_NON_GROUPING_FIELD_USED] = server.Non_Grouping_Field_Used
    _errno_map[ER_TABLE_CANT_HANDLE_SPKEYS] = server.Table_Cant_Handle_Spkeys
    _errno_map[ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA] = server.No_Triggers_On_System_Schema

%if MYSQL_VERSION >= 5002491:
    _errno_map[ER_USERNAME] = server.Username
    _errno_map[ER_HOSTNAME] = server.Hostname
    _errno_map[ER_WRONG_STRING_LENGTH] = server.Wrong_String_Length

%if MYSQL_VERSION >= 5002590:
    _errno_map[ER_REMOVED_SPACES] = server.Removed_Spaces
    _errno_map[ER_AUTOINC_READ_FAILED] = server.Autoinc_Read_Failed
    _errno_map[ER_NON_INSERTABLE_TABLE] = server.Non_Insertable_Table


def raise_error(errno, err_str):
    """Raise a MySQL exception.

    :Parameters:
        - `errno`: The error number.
        - `err_str`: The error string.
    """
    error = _errno_map.get(errno, client.Unknown_Error)
    raise error(errno, err_str)
