##############################################################################
#
# Copyright (c) 2007 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Setup for mysqldbda package

$Id: setup.py 86512 2008-05-06 14:23:11Z adamg $
"""
import os
from setuptools import setup, find_packages

def read(*rnames):
    return open(os.path.join(os.path.dirname(__file__), *rnames)).read()

setup(name='mysqldbda',
      version = '1.0.2',
      author='Zope Corporation and Contributors',
      author_email='zope-dev@zope.org',
      description='MySQL Database adapter',
      long_description=(
          read('src','mysqldbda','README.txt')
          + '\n\n' +
          'Detailed Dcoumentation\n' +
          '======================\n'
          + '\n\n' +
          read('CHANGES.txt')
          ),
      keywords = "mysql database adapter",
      classifiers = [
          'Development Status :: 5 - Production/Stable',
          'Environment :: Web Environment',
          'Intended Audience :: Developers',
          'License :: OSI Approved :: Zope Public License',
          'Programming Language :: Python',
          'Natural Language :: English',
          'Operating System :: OS Independent',
          'Topic :: Internet :: WWW/HTTP',
          'Framework :: Zope3'],
      url='http://pypi.python.org/pypi/mysqldbda',
      license='ZPL 2.1',
      packages=find_packages('src'),
      package_dir = {'': 'src'},
      install_requires = ['setuptools',
                          'zope.interface',
                          'zope.schema',
                          'zope.rdb',
                          'zope.publisher',
                          'zope.app.form',
                          ],
      include_package_data = True,
      zip_safe = False,
      )
