#!/usr/bin/env python
# -*- coding: utf-8 -*-
 
"""
    Module mytools.
    Tout les outils indispensables pour python
"""
import os, sys

 
__version__ = "0.0.3"

 
from mytools.parser import OptionParser
from mytools.mycmd import Cmd, OutColor
from mytools.consoleadvance import *


def we_are_frozen():
    # All of the modules are built-in to the interpreter, e.g., by py2exe
    return hasattr(sys, "frozen")

def module_path():
    encoding = sys.getfilesystemencoding()
    try: #for python2
        if we_are_frozen():
            return os.path.dirname(os.path.realpath(unicode(sys.executable, encoding)))
        return os.path.dirname(os.path.realpath(unicode(__file__, encoding)))
    except: #for python3
        if we_are_frozen():
            return os.path.dirname(os.path.realpath(sys.executable))
        return os.path.dirname(os.path.realpath(__file__))


