import sys
import cmd 
import os, os.path
import glob
import shutil
import colorconsole, colorconsole.terminal
import time
import shlex

#valid for python2 and python3
try:
    input = raw_input
except:
    pass

colorswin= { "0"   : "BLACK",
          "1"    : "BLUE",
          "2"   : "GREEN",
          "B"    : "CYAN",
          "C"     : "RED",
          "5"  : "PURPLE",
          "4"   : "BROWN",
          "7"   : "LGREY",
          "3"   : "DGRAY",
          "9"   : "LBLUE",
          "A"  : "LGREEN",
          "B"   : "LCYAN",
          "D"    : "LRED",
          "E"  : "YELLOW",
          "F"   : "WHITE"  }
        
class OutColor:

    result = ''
    fgdefault = None
    bkdefault = None
    endline = '\n'
    str_filter = ''

    def __init__(self, fgdefault='WHITE', bkdefault='BLACK'):
        self.cmd = None
        self.fgdefault = fgdefault
        self.bkdefault = bkdefault
        self.term = colorconsole.terminal.get_terminal()
        self.trace = False
        self.printer = True
        self.trace_path = None
        self.reset_result()
    
    def reset_result(self):
        self.result = ''
        self._endline =''
    
    def add_trace(self, text):
        try:
            if self.trace == True:
                if self.trace_path == None:
                    self.trace_path = os.path.join(os.getcwd(),str(int(time.time()))+'.log')
                r = open(self.trace_path,'a')
                r.write(text)
                r.close()
        except:
            pass
    
    def write(self, arg, colorfg=None, colorbk=None):
        if colorfg == None or colorfg not in colorconsole.terminal.colors.keys():
            colorfg = self.fgdefault
        if colorbk == None or colorbk not in colorconsole.terminal.colors.keys():
            colorbk = self.bkdefault
        
        if arg.find(self.str_filter) != -1:
            self.result = self.result + arg + self.endline
            self.add_trace("%s%s" % (arg, self.endline))
            self._endline = self.endline
            
            if self.printer == True:
                self.term.set_color(fg=colorconsole.terminal.colors[colorfg], bk=colorconsole.terminal.colors[colorbk])
                print(arg)
                self.term.set_color(fg=colorconsole.terminal.colors[self.fgdefault], bk=colorconsole.terminal.colors[self.bkdefault])

    def flush(self):
        sys.stdout.flush()        
        
    def restore_buffered_mode(self):
        self.term.restore_buffered_mode()

    def enable_unbuffered_input_mode(self):
        self.term.enable_unbuffered_input_mode()

    def putch(self, ch):
        self.term.putch(ch)

    def getch(self):
        return self.term.getch()

    def getche(self):
        return self.term.getche()

    def kbhit(self, timeout=0):       
        return self.term.kbhit(timeout)

    def no_colors(self):
        self.term.no_colors()    

    def set_color(self, fg = None, bk = None):
        if fg == None or fg not in colorconsole.terminal.colors.keys():
            fg = self.fgdefault
        if bk == None or bk not in colorconsole.terminal.colors.keys():
            bk = self.bkdefault
        self.term.set_color(fg=colorconsole.terminal.colors[fg], bk=colorconsole.terminal.colors[bk])
        
    def __get_console_info(self):
        return self.term.__get_console_info()
        
    def __get_text_attr(self):
          return self.term.__get_text_attr()
          
    def __set_text_attr(self, color):
          self.term.__set_text_attr(color)

    def set_title(self, title):
        self.term.set_title(title)

    def cprint(self, fg, bk, text):
        if fg == None or fg not in colorconsole.terminal.colors.keys():
            fg = self.fgdefault
        if bk == None or bk not in colorconsole.terminal.colors.keys():
            bk = self.bkdefault
        if text.find(self.str_filter) != -1:
            if len(text) > 0:
                self.result = self.result + text
            self.add_trace(text)
            self.term.cprint(colorconsole.terminal.colors[fg], colorconsole.terminal.colors[bk],text)

    def print_at(self, x, y, text):
        self.term.print_at(x, y, test)

    def clear(self):
        self.term.clear()                                      

    def gotoXY(self, x,y):
        self.term.gotoXY(x,y)

    def save_pos(self):
        self.save_pos()

    def restore_pos(self):
        self.term.restore_pos()

    def reset(self):
        self.term.reset()
        
    def __move_from(self, dx, dy):
        self.term.__move_from(dx, dy)

    def move_left(self, c = 1):
        self.term.move_left(c)

    def move_right(self, c = 1):
        self.term.move_right(c)

    def move_up(self, c = 1):
        self.term.move_up(c)

    def move_down(self, c = 1):
        self.term.move_down(c)

    def columns(self):
        return self.term.columns()
        
    def lines(self):
        return self.term.lines()
        
class Cmd(cmd.Cmd):
    prompt='>>>'
    _edit = 'edit'
    _clear = 'cls'
    _default= '.cmd.txt'
    _color = None
    _color_default_win = '0F'
    _multiligne_default = True
    _prompt_multiligne='.'
    _start_stop_multiligne='"""'
    color={ 'console' : None,
            'input' : None,
            'error'  :'LPURPLE',
            'prompt' : 'LBLUE',
            'dir' : 'LGREEN',
            'file' : None,
            'intro' : None
           }
    _unknowsyntax = '*** Unknown syntax: %s'
    _attr_not_print_conf = ['str_filter','lastcmd','cmdqueue','_endline','cmd','result','__module__','__doc__','_attr_not_print_conf','stdout', 'stdin','identchars','term','help_set_txt']
    _redirection = True
    _redirection_new = '>'
    _redirection_append = '>>'
    _filter = '|'
    commentary = '#'
    alias = {}
    arg_str = '"'
    _view_cmd_import = False
    help_set_txt = {
        '_endline':'end line for stdout',
        'bkdefault':'default background color',
        'fgdefault':'default foreground color',
        'printer':'print on stdout True or False',
        'trace':'activate trace True or False',
        'trace_path':'path of trace file',
        '_clear':'system command for clear console',
        '_color':'color for console only windows',
        '_color_default_win':'default color for console only windows',
        '_default':'conf file',
        '_edit':'system command for edit file',
        '_multiligne_default':'active manage of multiligne',
        '_prompt_multiligne':'replace prompt by character',
        '_redirection':'active redirection',
        '_redirection_append':'string for redirection by append',
        '_redirection_new':'string for redirection',
        '_start_stop_multiligne':'string for multiligne',
        '_unknowsyntax':'string for unknow syntax',
        'alias':'manage alias',
        'color["console"]':'color of console',
        'color["dir"]':'color of dir with ls ',
        'color["error"]':'color of error',
        'color["file"]':'color of file with ls',
        'color["input"]':'color of input',
        'color["intro"]':'color of intro',
        'color["prompt"]':'color of prompt',
        'commentary':'if line start with commentary',
        'completekey':'',
        'doc_header':'',
        'doc_leader':'',
        'intro':'it is printed out on interpreter startup',
        'misc_header':'',
        'nohelp':'',
        'prompt':'',
        'ruler':'sets the character used to draw separator lines in the help messages',
        'undoc_header':'',
        'use_rawinput':'',
        'last_cmd':'last command in console',
        'result':'last result in command',
        '_attr_not_print_conf':'list of attr not printed in conf',
        'help_set_txt':'dict for help set',
        'arg_str':'string separated for alias argument',
        '_filter':'char for active filter',
        '_view_cmd_import':'if True view cmd by import or alias'
    }
    
    
    def  __init__(self, completekey='tab', stdin=None, stdout=None, rc='default'):
        cmd.Cmd.__init__(self, completekey, stdin, stdout)
        if rc != None:
            self.do_import(rc)
    
    def default(self, line):
        """Called on an input line when the command prefix is not recognized.

        If this method is not overridden, it prints an error message and
        returns.

        """
        if self.treat_alias(line) == False:
            self.stdout.write(self._unknowsyntax % line, self.color['error'])

    def treat_alias(self, line): 
        if len([item for item in self.alias.keys() if line.startswith(item)])>0:
            cmd = [item for item in self.alias.keys() if line.startswith(item)][0]
            args = line.replace(cmd, '')[1:].lstrip().rstrip()
            strjoin =  self.arg_str + ',' +  self.arg_str
            argstr = self.arg_str + strjoin.join(shlex.split(args)) + self.arg_str
            try:
                if argstr == self.arg_str + self.arg_str: #not argument
                    line = self.alias[cmd]
                else:
                    exec("line = \"\"\"%s\"\"\".format(%s)" % (self.alias[cmd],argstr))
                try:
                    self.treat_cmds(iter(line.split('\n')))
                except Exception as e:
                    self.stdout.write(e, self.color['error'])  
            except Exception as e:
                self.stdout.write('error with argument alias, command is', self.color['error']) 
                self.stdout.write(self.alias[cmd], self.color['error']) 
                self.stdout.write(str(e), self.color['error'])
             
            return True
        else:
            return False
    
    def complete(self, text, line, begidx, endidx):
        """
        Only gets here onced args have been typed in...
        completion of the 'command' by itself does not call this
        """

        # parse out command (could be a partial command)
        command = line.split(' ', 1)[0]
        
        # generates a list of commands...
        # from all methods in this class that start with 'do_'
        commands = [ i[3:] for i in dir(self) if i.startswith('do_') ]
        print(commands)

        # auto-complete the command
        command = [ i for i in commands if i.startswith(command) ]

        # can not complete a partial arg if...
        # the command can not be found/completed
        if len(command) != 1:
            return [text]

        # calls do_{command} method to load self.params
        getattr(self, 'do_' + command[0])(None)
        return self.params.parse(line, do=False)
        
    def cmdloop(self, intro=None):
        ### extract from cmd.py
        """Repeatedly issue a prompt, accept input, parse an initial prefix
        off the received input, and dispatch to action methods, passing them
        the remainder of the line as argument.

        """

        self.preloop()
        if self.use_rawinput and self.completekey:
            try:
                import readline
                self.old_completer = readline.get_completer()
                readline.set_completer(self.complete)
                readline.parse_and_bind(self.completekey+": complete")
            except ImportError:
                pass
        try:
            if intro is not None:
                self.intro = intro
            if self.intro:
                self.stdout.write(str(self.intro)+"\n", self.color['intro'])
            stop = None
            while not stop:
                if self.cmdqueue:
                    line = self.cmdqueue.pop(0)
                else:
                    if self.use_rawinput:
                        try:
                            ### change here
                            self.stdout.cprint( self.color['prompt'],None,self.prompt)
                            self.stdout.set_color(self.color['input'],None)
                            line = input('') #raw_input
                            self.stdout.add_trace(line+'\n')
                            if line != '':
                                if line.startswith(self.commentary) == True:
                                    line = ''
                                if line.count(self._start_stop_multiligne) == 1:
                                    loop = True
                                    promptmultiligne = self._prompt_multiligne * len(self.prompt)
                                    while loop == True:
                                        self.stdout.cprint( self.color['prompt'],None, promptmultiligne)
                                        self.stdout.set_color(self.color['input'],None)
                                        line1 = input('')
                                        self.stdout.add_trace(line1+'\n')
                                        if line1.startswith(self.commentary) == False:
                                            line = line + '\n' + line1
                                            if line1.count(self._start_stop_multiligne) == 1:
                                                loop = False
                                elif line == '' or (self._multiligne_default == True and 'do_' + self.parseline(line)[0] not in dir(self) and len([item for item in self.alias.keys() if line.startswith(item)])==0): #not cmd in line
                                    loop = True
                                    promptmultiligne = self._prompt_multiligne * len(self.prompt)
                                    while loop == True:
                                        self.stdout.cprint( self.color['prompt'],None, promptmultiligne)
                                        self.stdout.set_color(self.color['input'],None)
                                        line1 = input('')
                                        self.stdout.add_trace(line1+'\n')
                                        if line1.startswith(self.commentary) == False:
                                            line = line + '\n' + line1
                                            if line1 == '':
                                                loop = False
                                                line= line[:-1]
                                
                            ### end change here
                        except EOFError:
                            line = 'EOF'
                    else:
                        self.stdout.write(self.prompt)
                        self.stdout.flush()
                        line = self.stdin.readline()
                        if not len(line):
                            line = 'EOF'
                        else:
                            line = line.rstrip('\r\n')
                ### change here
                self.stdout.set_color(None,None)
                line = line.rstrip()
                if self.parseline(line)[0] != 'print':
                    self._reset_result()
                # manage redirection    
                redirect = False
                if self._redirection == True:
                    if line.split(' ')[-1].startswith(self._redirection_append):
                        redirect_append = True
                        redirect = True
                        path_redirect = line.split(' ')[-1][len(self._redirection_append):]
                        line = ' '.join(line.split(' ')[:-1])
                    if line.split(' ')[-1].startswith(self._redirection_new):
                        redirect_append = False
                        redirect = True
                        path_redirect = line.split(' ')[-1][len(self._redirection_new):]
                        line = ' '.join(line.split(' ')[:-1])
                #manage filter stdout
                if line.split(' ')[-1].startswith(self._filter):
                    filter = line.split(' ')[-1][len(self._filter):]
                    self.stdout.str_filter = filter
                    line = ' '.join(line.split(' ')[:-1])
                ### end change here                
                line = self.precmd(line)
                stop = self.onecmd(line)
                stop = self.postcmd(stop, line)
                ### change here
                try:
                    if redirect == True:
                        self._redirect_save(path_redirect, redirect_append)
                except Exception as e:
                    self.stdout.write("error with redirect %s" % path_redirect, self.color['error'])
                    self.stdout.write(str(e), self.color['error'])
                self.stdout.str_filter=''    
                ### end change here
            self.postloop()
        finally:
            if self.use_rawinput and self.completekey:
                try:
                    import readline
                    readline.set_completer(self.old_completer)
                except ImportError:
                    pass
    
    def _redirect_save(self, path_redirect, append):
        if append == True:
            r = open(os.path.join(os.getcwd(),path_redirect), 'a')
        else:
            r = open(os.path.join(os.getcwd(),path_redirect), 'w')
        r.write(self.stdout.result+'\n')
        r.close()

    def _reset_result(self):
        self.stdout.reset_result()
                    
    def emptyline(self):
        pass
                    
    def do_help(self, arg):
        """help of cmd"""
        if arg:
            # XXX check arg syntax
            try:
                func = getattr(self, 'help_' + arg)
            except AttributeError:
                try:
                    doc=getattr(self, 'do_' + arg).__doc__
                    if doc:
                        self.stdout.write(' '* len(self.prompt)+ "%s\n"%str(doc), self.color['console'])
                        return
                except AttributeError:
                    pass
                self.stdout.write(' '* len(self.prompt)+"%s\n"%str(self.nohelp % (arg,)), self.color['console'])
                return
            func()
        else:
            names = self.get_names()
            cmds_doc = []
            cmds_undoc = []
            help = {}
            ln = 0
            for name in names:
                if name[:3] == 'do_' and len(name) -2 > ln:
                    ln = len(name) -2
            names.sort()
            # There can be duplicates if routines overridden
            prevname = ''
            for name in names:
                if name[:3] == 'do_':
                    if name == prevname:
                        continue
                    prevname = name
                    cmd=name[3:]
                    if getattr(self, name).__doc__:
                        self.stdout.write(' '* len(self.prompt)+ '%s:%s' % (cmd.ljust(ln), getattr(self, name).__doc__), self.color['console'])
                    else:
                        self.stdout.write(' '* len(self.prompt)+ cmd, self.color['console'])
    
    def do_python(self, arg):
        try:
            exec(arg)        
        except Exception as e:
            self.stdout.write(str(e), self.color['error'])
    
    def do_set(self, arg):
        """manage attribut of console"""
        try:
            name = arg.split('=')[0]
            if name == '_color' and arg.split('=')[1] != 'None':
                exec('self.%s' % arg)
                self.change_color(self._color)
                return
            if '[' in name:
                name = name.split('[')[0]
            if name == 'title':
                exec("title=%s" % '='.join(arg.split('=')[1:]))                
                self.stdout.set_title(title)
                return
            if name in dir(self):
                exec('self.%s' % arg)
                return
            if name in dir(self.stdout):
                exec('self.stdout.%s' % arg)
                return
            raise AttributeError('')
        except Exception as e:
            self.stdout.write("format of set is name = value or name doesnt exist", self.color['error'])
            self.stdout.write(arg, self.color['error'])
            
    def do_pwd(self, arg):
        """current path"""
        try:
            self.stdout.write(os.getcwd(), self.color['console']) 
        except Exception as e:
            self.stdout.write(e, self.color['error'])     
            
    def do_cd(self, arg):
        """change current path"""
        try:
            os.chdir(os.path.join(os.getcwd(),arg))  
        except Exception as e:
            self.stdout.write(e, self.color['error'])         
            
    def do_ls(self, arg):
        """explore current path"""
        lstd, lstf = self._getlistdir()
        for i in lstd:
            self.stdout.write(i, self.color['dir'])
        for i in lstf:
            self.stdout.write(i, self.color['file'])    
            
    def do_ld(self, arg):
        """explore dir of current path"""
        lstd, lstf = self._getlistdir()
        for i in lstd:
            self.stdout.write(i, self.color['dir'])
            
    def do_mkdir(self, arg):
        """create path"""
        try:
            os.makedirs(arg)
            self.stdout.write('%s is created' % arg, self.color['console']) 
        except Exception as e:
            self.stdout.write(e, self.color['error'])     
    
    def do_lf(self, arg):
        """explore file of current path"""
        lstd, lstf = self._getlistdir()
        for i in lstf:
            self.stdout.write(i, self.color['file'])
    
    def _getlistdir(self):
        lstd, lstf = [], []
        for i in os.listdir(os.getcwd()):
            if os.path.isfile(i):
                lstf.append(i)
            else:
                lstd.append(i)
        return lstd, lstf            
        
    def do_bye(self, arg):
        """quit console"""
        if os.name == "nt":
            os.system('color %s' % self._color_default_win) #reset color
        sys.exit(1)           
        
    def do_clear(self, arg):
        """clear console"""
        os.system(self._clear)
        self._reset_result()
        
    def do_print(self, arg):
        """print attribute console"""
        try:
            if arg == 'conf':
                self.print_conf()
                return
            if arg in dir(self):
                exec('txt = str(self.%s)' % arg)
                self.stdout.write(txt, self.color['console'])
                return
            if arg in dir(self.stdout):
                exec('txt = str(self.stdout.%s)' % arg)
                self.stdout.write(txt, self.color['console'])
                return
            raise AttributeError('')
        except Exception as e:
            self.stdout.write('%s not exist' % arg, self.color['error'])   
    
    def change_color(self,arg):
        """change color console. ONLY WINDOWS!!!!"""
        try:
            if arg[0] in colorswin.keys():
                self.do_set('bkdefault="%s"' % colorswin[arg[0]])
            if arg[1] in colorswin.keys():
                self.do_set('fgdefault="%s"' % colorswin[arg[1]])
            os.system('color %s' % arg)
        except Exception as e:
            self.stdout.write(e, self.color['error'])    

    def do_edit(self,arg):
        """edit file"""
        try:
            if os.path.isfile(os.path.join(os.getcwd(),arg)) == False:
                open(os.path.join(os.getcwd(),arg),'w').close() #create file
            os.system(r'%s %s' % (self._edit, arg))
        except Exception as e:
            self.stdout.write(e, self.color['error'])    

    def do_rm(self,arg):
        """delete file or tree (-r)"""
        try:
            if arg[:3] == "-r ":
                shutil.rmtree(arg[3:])
            else:
                os.remove(arg)
            self.stdout.write('rm %s is ok' % arg, self.color['console'])
        except Exception as e:
            self.stdout.write(e, self.color['error'])   

    def get_path(self, arg):
        path = None
        if os.path.isfile(os.path.join(os.getcwd(),arg)): path = os.path.join(os.getcwd(),arg)
        try: #only windows
            if os.path.isfile(os.path.join(os.getenv('USERPROFILE'),arg)): path = os.path.join(os.getenv('USERPROFILE'),arg)
        except Exception as e:
            pass
        try: #only unix
            if os.path.isfile(os.path.join(os.getenv('HOME'),arg)): path = os.path.join(os.getenv('HOME'),arg)
        except Exception as e:
            pass
        if os.path.isfile(arg): path = arg
        return path
    
    def do_import(self,arg):
        """import file as commands"""
        path = None
        default = False
        if arg == 'default':
            arg = self._default
            default = True
        try:
            path = self.get_path(arg)
            if path == None:
                raise AttributeError('%s is not a file' % arg)
            fil = open(path,'r')
            lst = iter(fil.readlines())
            self.treat_cmds(lst)
        except Exception as e:
            if default == False:
                self.stdout.write(e, self.color['error'])    
    
    def treat_cmds(self, lst):
        while 1:
            try:
                line = next(lst)
            except:
                line = ''
            if line.startswith(self.commentary) == False:
                if not line:
                    break          
                if line.count(self._start_stop_multiligne) == 1:
                    loop = True
                    while loop == True:
                        try:
                            line1 = lst.next()
                        except:
                            line1 = ''
                        if not line1:
                            break
                        if line1.startswith(self.commentary) == False:
                            line = line + line1
                            if line1.rstrip()[-3:] == self._start_stop_multiligne:
                                loop = False
                elif self._multiligne_default == True and ('do_' + self.parseline(line)[0] not in dir(self)  and len([item for item in self.alias.keys() if line.startswith(item)])==0): #not cmd in line
                    loop = True
                    while loop == True:
                        try:
                            line1 = lst.next()
                        except:
                            line1 = ''
                        if not line1:
                            break
                        if line1.startswith(self.commentary) == False:
                            line = line + line1
                            if line1 == '' or line1 == '\n':
                                loop = False
                                line= line[:-1]
                if self._view_cmd_import == True:
                    self.stdout.write(line, self.color['console'])                    
                self.onecmd(line)
    
    def print_conf(self):
        """print conf"""
        try:
            dic = {}
            for i in dir(self.stdout):
                if not callable(getattr(self.stdout,i)) and i not in self._attr_not_print_conf:
                    exec("s = self.stdout.%s" % i)
                    dic = self.prinf_conf_attr(s,dic,i)
            lst = dic.keys()
            lst.sort()
            self.stdout.write('%s conf of stdout' % self.commentary)
            for i in lst:
                self.stdout.write('set '+ i +'='+ dic[i], self.color['console'])
            dic={}
            for i in dir(self):
                if not callable(getattr(self,i)) and i not in self._attr_not_print_conf:
                    exec("s = self.%s" % i)
                    dic = self.prinf_conf_attr(s,dic,i)
            lst = dic.keys()
            lst.sort()
            self.stdout.write('%s conf of console' % self.commentary)
            for i in lst:
                self.stdout.write('set '+ i +'='+ dic[i], self.color['console'])
        except Exception as e:
            self.stdout.write(e, self.color['error'])   
    
    def prinf_conf_attr(self, obj, dic, id):
        if isinstance(obj, str) : 
            if '\n' in obj:
                dic[id]= self._start_stop_multiligne + obj + self._start_stop_multiligne
            elif '"' not in obj:
                dic[id]='"' + obj + '"'
            else:
                dic[id]="'" + obj + "'"
        elif isinstance(obj, dict):
            for j in obj.keys():
                dic = self.prinf_conf_attr(obj[j],dic,id+"['"+j+"']")
        else:
            dic[id]=str(obj)
        return dic

    def help_set(self):
        lst = self.help_set_txt.keys()
        lst.sort()
        x= 0
        for i in lst:
            if len(i) > x: x=len(i)
        for i in lst:
            self.stdout.write(' '* len(self.prompt) + i.ljust(x+1) + self.help_set_txt[i], self.color['console'])
        
    #do_quit = do_bye
    do_vi = do_edit
    do_ll = do_ls
        
        

