#!/usr/bin/env python
# -*- coding: utf-8 -*-
""" 
    util for mytool
"""
import logging
import logging.handlers
import sys
import os
import colorconsole, colorconsole.terminal

#__all__ = ['Logger']

FORMAT_FILE = '%(asctime)s : %(levelname)s - %(name)s - %(module)s \ %(funcName)s : %(message)s' 
FORMAT_STREAM = '%(asctime)s : %(levelname)s - %(name)s - %(module)s \ %(funcName)s : %(message)s' 

CRITICAL = logging.CRITICAL
FATAL = CRITICAL
ERROR = logging.ERROR
WARNING = logging.WARNING
WARN = WARNING
INFO = logging.INFO
DEBUG = logging.DEBUG



class Singleton(object):
    """ all same instance """
    _ref = None
    def __new__(cls, *args, **kw):
        if cls._ref is None:
            cls._ref = super(Singleton, cls).__new__(cls, *args, **kw)
        return cls._ref

class StreamHandlerColor(logging.StreamHandler):

    def __init__(self, stream=None,  fg='WHITE'):
        logging.StreamHandler.__init__(self, stream)
        self._fg = {}
        self._fg[0] =  colorconsole.terminal.colors[fg] #NOSET
        self._fg[10] = colorconsole.terminal.colors['LGREY'] #DEBUG
        self._fg[20] = colorconsole.terminal.colors['GREEN'] #INFO
        self._fg[30] = colorconsole.terminal.colors['YELLOW'] #WARNING
        self._fg[40] = colorconsole.terminal.colors['LRED'] #ERROR
        self._fg[50] = colorconsole.terminal.colors['RED'] #CRITICAL
        self.screen = colorconsole.terminal.get_terminal()

    def emit(self, record):
        self.screen.set_color(self._fg[record.levelno], None) 
        logging.StreamHandler.emit(self, record)
        self.screen.set_color(self._fg[0], None)

class Logger(Singleton):

    def __init__(self, level=logging.CRITICAL):
        """generate a unique logger"""
        self._logger = logging.getLogger('MyLogger')
        self._logger.setLevel(level)
  
    def add_rotating_file(self, path='log.txt', size=1024, cnt=5):
        handler = logging.handlers.RotatingFileHandler(
                      path, maxBytes=size, backupCount=cnt)
        formatter = logging.Formatter(FORMAT_FILE)
        handler.setFormatter(formatter)
        self._logger.addHandler(handler)

    def add_stream(self, stream=None):
        handler = StreamHandlerColor(stream)
        formatter = logging.Formatter(FORMAT_STREAM)
        handler.setFormatter(formatter)
        self._logger.addHandler(handler)

    def debug(self, msg):
        self._logger.debug(msg)
    
    def info(self, msg):
        self._logger.info(msg)
    
    def warn(self, msg):
        self._logger.warn(msg)
    
    def error(self, msg):
        self._logger.error(msg)
    
    def critical(self,txt):
        self._logger.critical(txt)
    
    def setLevel(self,level):
        self._logger.setLevel(level)
    

