#!/usr/bin/env python
# -*- coding: utf-8 -*-
 
"""
    Implémentation de parser avec de la couleur
"""

import colorconsole, colorconsole.terminal
import os, sys
import optparse

__all__ = ['OptionParser']

class OptionParser(optparse.OptionParser):

    def __init__(self, screen=None, **kw):
        optparse.OptionParser.__init__(self, **kw)
        if screen == None:
            screen = colorconsole.terminal.get_terminal()
        self.screen = screen    
    
    def exit(self, status=0, msg=None):
        if msg:
            sys.stderr.write(msg)
        self.screen.set_color(colorconsole.terminal.colors["WHITE"], colorconsole.terminal.colors["BLACK"])
        sys.exit(status) 
    
    def error(self, msg):
        self.screen.set_color(colorconsole.terminal.colors["LRED"], None) 
        optparse.OptionParser.error(self, msg)
   
    def print_version(self, file=None):
        self.screen.set_color(colorconsole.terminal.colors["LGREEN"],None)
        optparse.OptionParser.print_version(self, file)
        self.screen.set_color(colorconsole.terminal.colors["WHITE"], colorconsole.terminal.colors["BLACK"])

    def print_help(self, file=None):
        self.screen.set_color(colorconsole.terminal.colors["LGREEN"],None)
        optparse.OptionParser.print_help(self, file)
        self.screen.set_color(colorconsole.terminal.colors["WHITE"], colorconsole.terminal.colors["BLACK"])

    def print_info(self, msg=""):
        self.screen.set_color(colorconsole.terminal.colors["LGREEN"],None)
        print(msg)
        self.screen.set_color(colorconsole.terminal.colors["WHITE"], colorconsole.terminal.colors["BLACK"])

    def print_stdout(self, msg, fg="WHITE", bg="BLACK"):
        self.screen.set_color(colorconsole.terminal.colors[fg],colorconsole.terminal.colors[bg])
        sys.stdout.write(msg)
        self.screen.set_color(colorconsole.terminal.colors["WHITE"], colorconsole.terminal.colors["BLACK"])

    def get_formatwidth(self, default=80):
        try:
            width = int(os.environ['COLUMNS'])
        except (KeyError, ValueError):
            width = default
        return "%-"+str(width)+"s"


