#!/usr/bin/env python
# -*- coding: utf-8 -*-
""" 
    util for mytool
"""
import logging
import logging.handlers
import sys
import os
import colorconsole, colorconsole.terminal

__all__ = ['Logger', 'CRITICAL', 'FATAL', 'ERROR', 'WARNING', 'INFO', 'DEBUG',
            'NOTSET', 'NOTE', 'FORMAT_FILE', 'FORMAT_STREAM' ]

FORMAT_FILE = '%(asctime)s : %(levelname)s - %(name)s - %(module)s \ %(funcName)s : %(message)s' 
FORMAT_STREAM = '%(asctime)s : %(levelname)s - %(name)s - %(module)s \ %(funcName)s : %(message)s' 

CRITICAL = logging.CRITICAL
FATAL = CRITICAL
ERROR = logging.ERROR
WARNING = logging.WARNING
WARN = WARNING
INFO = logging.INFO
DEBUG = logging.DEBUG
NOTSET = logging.NOTSET

logging.NOTE = 90
NOTE = logging.NOTE
logging.addLevelName(logging.NOTE, 'NOTE')

logging._levelNames['NOTE'] = logging.NOTE
logging._levelNames[logging.NOTE] = 'NOTE'

class Singleton(object):
    """ all same instance """
    _ref = None
    def __new__(cls, *args, **kw):
        if cls._ref is None:
            cls._ref = super(Singleton, cls).__new__(cls, *args, **kw)
        return cls._ref

class StreamHandlerColor(logging.StreamHandler):

    def __init__(self, stream=None,  fg='WHITE'):
        logging.StreamHandler.__init__(self, stream)
        self._fg = {}
        self._fg[0] =  colorconsole.terminal.colors[fg] #NOTSET
        self._fg[10] = colorconsole.terminal.colors['LGREY'] #DEBUG
        self._fg[20] = colorconsole.terminal.colors['GREEN'] #INFO
        self._fg[30] = colorconsole.terminal.colors['YELLOW'] #WARNING
        self._fg[40] = colorconsole.terminal.colors['LRED'] #ERROR
        self._fg[50] = colorconsole.terminal.colors['RED'] #CRITICAL
        self._fg[90] =  colorconsole.terminal.colors[fg] #NOTE
        self.screen = colorconsole.terminal.get_terminal()

    def emit(self, record):
        self.screen.set_color(self._fg[record.levelno], None) 
        logging.StreamHandler.emit(self, record)
        self.screen.set_color(self._fg[0], None)

class Logger(Singleton):

    def __init__(self, level=NOTSET):
        """generate a unique logger"""
        self._logger = logging.getLogger('MyLogger')
        if level != NOTSET:
            self._logger.setLevel(level)
  
    def add_rotating_file(self, path='log.txt', size=1024, cnt=5, form=FORMAT_FILE):
        handler = logging.handlers.RotatingFileHandler(
                      path, maxBytes=size, backupCount=cnt)
        formatter = logging.Formatter(form)
        handler.setFormatter(formatter)
        self._logger.addHandler(handler)

    def add_stream(self, stream=None, form=FORMAT_STREAM):
        handler = StreamHandlerColor(stream)
        formatter = logging.Formatter(form)
        handler.setFormatter(formatter)
        self._logger.addHandler(handler)

    def debug(self, msg):
        self._logger.debug(msg)
    
    def info(self, msg):
        self._logger.info(msg)
    
    def warn(self, msg):
        self._logger.warn(msg)

    warning = warn 
    
    def error(self, msg):
        self._logger.error(msg)
   
    def exception(self, msg):
        self.error(msg)

    def critical(self, msg):
        self._logger.critical(msg)

    def note(self, msg):
        self._logger.log(NOTE, msg)
     
    def setLevel(self, level):
        self._logger.setLevel(level)
    
    def log(self, level, msg):
        if not isinstance(level, int):
            level = logging._levelNames.get(level.upper(), 0)
        self._logger.log(level, msg)
