import sys
import subprocess

if sys.platform == 'linux2':
    import pynotify as notify
    import gtk
else:
    import Growl as notify

def display_notification(command, return_code):
    if return_code == 0:
        description = u'finished successfully'
    else:
        description = u'finished with return code %s' % return_code

    if hasattr(notify, 'GrowlNotifier'):
        g = notify.GrowlNotifier(u'naf', notifications=['command_finished',])
        g.register()
        g.notify('command_finished', command, description)
    elif hasattr(notify, 'Notification'):
        if return_code == 0:
            icon = gtk.STOCK_DIALOG_INFO
        else:
            icon = gtk.STOCK_DIALOG_ERROR
        notification = notify.Notification(command, description, icon)
        notification.show()

def run_command():
    if len(sys.argv) < 2:
        print 'Usage: naf <command_to_run>'
        sys.exit(1)
    command_string = u' '.join(sys.argv[1:])
    return_code = subprocess.call(command_string, shell=True)

    display_notification(command_string, return_code)

    sys.exit(return_code)

def main():
    try:
        run_command()
    except KeyboardInterrupt:
        sys.exit("KeyboardInterrupt")

if __name__ == '__main__':
    main()
