# -*- coding: utf-8 -*-
import re

re_spaces = re.compile(r"\s+", re.U)
re_word = re.compile(r"\w+", re.U)
re_mac = re.compile(r'^(ma?c)(\w+)', re.I | re.U)
re_initial = re.compile(r'^(\w\.|[A-Z])?$', re.U)
re_nickname = re.compile(r'\s*?[\("](.+?)[\)"]', re.U)
re_roman_numeral = re.compile(r'^(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})$', re.I | re.U)

# PUNC_TITLES could be names or titles, but if they
# have a period at the end they're a title
PUNC_TITLES = ('hon.',)

# PREFIXES are words that prefix last names. Can be chained like "de la Vega"
# these should not be more common as first or middle names than prefixes
PREFIXES = set([
    'abu',
    'bon',
    'bin',
    'da',
    'dal',
    'de',
    'del',
    'der',
    'de',
    'di',
    u'dí',
    'ibn',
    'la',
    'le',
    'san',
    'st',
    'ste',
    'van',
    'vel',
    'von',
])
SUFFIXES = set([
    'esq',
    'esquire',
    'jr',
    'sr',
    '2',
    'i',
    'ii',
    'iii',
    'iv',
    'v',
    'clu',
    'chfc',
    'cfp',
    'md',
    'phd',
    'mp',
    'qc',
])
CAPITALIZATION_EXCEPTIONS = (
    ('ii' ,'II'),
    ('iii','III'),
    ('iv' ,'IV'),
    ('md' ,'M.D.'),
    ('phd','Ph.D.'),
)
CONJUNCTIONS = set(['&','and','et','e','of','the','und','y',])


# ## Titles ##
# 
# TITLES: Cannot include things that could also be first names, e.g. "dean"
# many of these from wikipedia: https://en.wikipedia.org/wiki/Title
# The parser recognizes chains of these including conjunctions allowing 
# recognition titles like "Deputy Secretary of State"


# FIRST_NAME_TITLES: When these titles are used with a single name, 
# that name is a first name rather than a last name.
FIRST_NAME_TITLES = set([
    'sir',
    'dame',
    'king',
    'queen',
    'master',
    'maid',
    'uncle',
    'auntie',
    'aunt',
    'brother',
    'sister',
    'mother',
    'father',
    'pope',
])

TITLES = FIRST_NAME_TITLES | set([
    'dr',
    'doctor',
    'miss',
    'misses',
    'mr',
    'mister',
    'mrs',
    'ms',
    'rev',
    'madam',
    'madame',
    'ab',
    '2ndlt',
    'amn',
    '1stlt',
    'a1c',
    'capt',
    'sra',
    'maj',
    'ssgt',
    'ltcol',
    'tsgt',
    'col',
    'briggen',
    '1stsgt',
    'majgen',
    'smsgt',
    'ltgen',
    '1stsgt',
    'cmsgt',
    '1stsgt',
    'ccmsgt',
    'cmsaf',
    'pvt',
    '2lt',
    'pv2',
    '1lt',
    'pfc',
    'cpt',
    'spc',
    'maj',
    'cpl',
    'ltc',
    'sgt',
    'ssg',
    'bg',
    'sfc',
    'mg',
    'msg',
    'ltg',
    '1sgt',
    'sgm',
    'csm',
    'sma',
    'wo1',
    'wo2',
    'wo3',
    'wo4',
    'wo5',
    'ens',
    'sa',
    'ltjg',
    'sn',
    'lt',
    'po3',
    'lcdr',
    'po1',
    'po2',
    'cdr',
    'cpo',
    'scpo',
    'mcpo',
    'vadm',
    'mcpoc',
    'adm',
    'mpco-cg',
    '2ndlt',
    'pfc',
    '1stlt',
    'lcpl',
    'cpl',
    'sgt',
    'ssgt',
    'gysgt',
    'bgen',
    'msgt',
    'majgen',
    '1stsgt',
    'ltgen',
    'mgysgt',
    'gen',
    'sgtmaj',
    'sgtmajmc',
    'wo-1',
    'cwo-2',
    'cwo-3',
    'cwo-4',
    'cwo-5',
    'rdml',
    'radm',
    'mcpon',
    'fadm',
    'wo1',
    'cwo2',
    'cwo3',
    'cwo4',
    'cwo5',
    'rt',
    'lord',
    'lady',
    'duke',
    'dutchess',
    'representative',
    'senator',
    'cardinal',
    'secretary',
    'state',
    'foreign',
    'minister',
    'speaker',
    'president',
    'pres',
    'ceo',
    'cfo',
    'deputy',
    'dpty',
    'executive',
    'exec',
    'vice',
    'vc',
    'councillor',
    'manager',
    'mgr',
    'alderman',
    'delegate',
    'mayor',
    'lieutenant',
    'governor',
    'prefect',
    'prelate',
    'premier',
    'burgess',
    'ambassador',
    'envoy',
    'secretary',
    u"attaché",
    u"chargé d'affaires",
    'provost',
    "marquis",
    "marquess",
    "marquise",
    "marchioness",
    'archduke',
    'archduchess',
    'viscount',
    'baron',
    'emperor',
    'empress',
    'tsar',
    'tsarina',
    'leader',
    'abbess',
    'abbot',
    'friar',
    'superior',
    'reverend',
    'bishop',
    'archbishop',
    'metropolitan',
    'presbyter',
    'priest',
    'high',
    'priestess',
    'patriarch',
    'catholicos',
    'vicar',
    'chaplain',
    'canon',
    'pastor',
    'prelate',
    'primate',
    'chaplain',
    'cardinal',
    'servant',
    'venerable',
    'blessed',
    'saint',
    'member',
    'solicitor',
    'mufti',
    'grand',
    'chancellor',
    'barrister',
    'bailiff',
    'attorney',
    'advocate',
    'deacon',
    'archdeacon',
    'acolyte',
    'elder',
    'minister',
    'monsignor',
    'almoner',
    'prof',
    'colonel',
    'general',
    'commodore',
    'air',
    'corporal',
    'staff',
    'chief',
    'first',
    'sergeant',
    'admiral',
    'high',
    'rear',
    'brigadier',
    'captain',
    'group',
    'commander',
    'commander-in-chief',
    'wing',
    'general',
    'adjutant',
    'director',
    'dir',
    'generalissimo',
    'resident',
    'surgeon',
    'officer',
    'controller',
    'academic',
    'analytics',
    'business',
    'credit',
    'financial',
    'information',
    'security',
    'knowledge',
    'marketing',
    'operating',
    'petty',
    'risk',
    'security',
    'strategy',
    'technical',
    'warrant',
    'corporate',
    'customs',
    'field',
    'flag',
    'flying',
    'intelligence',
    'pilot',
    'police',
    'political',
    'revenue',
    'senior',
    'sr',
    'junior',
    'jr',
    'staff',
    'private',
    'principal',
    'prin',
    'coach',
    'nurse',
    'nanny',
    'docent',
    'lama',
    'druid',
    'archdruid',
    'rabbi',
    'rebbe',
    'buddha',
    'ayatollah',
    'imam',
    'bodhisattva',
    'mullah',
    'mahdi',
    'saoshyant',
    'tirthankar',
    'vardapet',
    'pharaoh',
    'sultan',
    'sultana',
    'maharajah',
    'maharani',
    'elder',
    'vizier',
    'chieftain',
    'comptroller',
    'courtier',
    'curator',
    'doyen',
    'edohen',
    'ekegbian',
    'elerunwon',
    'forester',
    'gentiluomo',
    'headman',
    'intendant',
    'lamido',
    'marcher',
    'matriarch',
    'patriarch',
    'prior',
    'pursuivant',
    'rangatira',
    'ranger',
    'registrar',
    'seigneur',
    'shehu',
    'sheikh',
    'sheriff',
    'subaltern',
    'subedar',
    'sysselmann',
    'timi',
    'treasurer',
    'verderer',
    'warden',
    'hereditary',
    'woodman',
    'bearer',
    'banner',
    'swordbearer',
    'apprentice',
    'journeyman',
    'adept',
    'akhoond',
    'arhat',
    'bwana',
    'goodman',
    'goodwife',
    'bard',
    'hajji',
    'mullah',
    'baba',
    'effendi',
    'giani',
    'gyani',
    'guru',
    'siddha',
    'pir',
    'murshid',
    'attache',
    'prime',
    'united',
    'states',
    'national',
    'associate',
    'assoc',
    'assistant',
    'asst',
    'supreme',
    'appellate',
    'judicial',
    "queen's",
    "king's",
    'prince',
    'princess',
    'bench',
    'right',
    'majesty',
    'his',
    'her',
    'kingdom',
    'royal',
    'right',
    'honorable',
    'honourable',
    'magistrate',
    'mag',
    'judge',
    'designated',
    'us',
    'federal',
    'district',
    'arbitrator',
    'pro',
    'se',
    'law',
    'clerk',
    'docket',
    'pslc',
    'special',
    'municipal',
    'tax',
    'civil',
    'criminal',
    'family',
    'presiding',
    'division',
    'edmi', #is this also a first name?
    'discovery',
    'magistrate-judge',
    'mag-judge',
    'senior-judge',
    'mag/judge',
    
])


# pre v0.2.5 support
PREFICES = PREFIXES 
SUFFICES = SUFFIXES
