#!/usr/bin/env python
# coding: utf-8

import os
from distutils.core import setup

root = os.path.dirname(__file__)

data = [
    ('/usr/lib/nautilus/extensions-2.0/python',
     [os.path.join(root, 'src/nautilus-xsnippet.py')]),

    ('/usr/share/pixmaps/',
     [os.path.join(root, 'src/pixmaps/nautilus-xsnippet.png')]),
]

setup(
    name='nautilus-xsnippet',
    description='Nautilus Xsnippet Extension',
    long_description=open('README').read(),
    classifiers=[
        "Operating System :: POSIX :: Linux",
        "Topic :: Desktop Environment :: File Managers",
        "Topic :: Desktop Environment :: Gnome",
        "Environment :: Plugins",
    ],
    version='0.1.5',
    author='Igor Kalnitsky',
    author_email='igor@kalnitsky.org',
    url='http://www.kalnitsky.org/',
    license='GPL-3',
    platforms=['Linux'],
    keywords=['nautilus', 'xsnippet', 'extension'],
    data_files=data,
)
