import nefis
import numpy as np

def test_nefis_attributes():
    #-------------------------------------------------------------------------------
    error, version = nefis.getnfv()
    print('')
    print('%s' % version[14:])
    print('')
    #-------------------------------------------------------------------------------
    dat_file = 'attributes.dat'
    def_file = 'attributes.def'
    coding = ' '
    ac_type = 'c'
    fp = -1
    print("---------")
    print(dat_file)
    print(def_file)
    print(coding)
    print(ac_type)
    print("---------")

    #-------------------------------------------------------------------------------
    error, fp = nefis.crenef(dat_file, def_file, coding, ac_type)
    print("---------")
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    elm_name = 'Element 1'
    elm_type = 'character'
    elm_single_byte = 20
    elm_quantity = 'names'
    elm_unit = '[-]'
    elm_description = 'Discharge station names'
    elm_count = 1
    #elm_data = np.arange(15).reshape(5,3)
    elm_dimensions = np.arange(elm_count).reshape(elm_count)
    elm_dimensions[0] = 20
    error = nefis.defelm(fp, elm_name, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    elm_name = 'Elm 2'
    elm_type = 'REAL'
    elm_single_byte = 4
    elm_quantity = 'discharge'
    elm_unit = '[m^3/s]'
    elm_description = 'First element generated by Python'
    elm_count = 2
    #elm_data = np.arange(15).reshape(5,3)
    elm_dimensions = np.arange(elm_count).reshape(elm_count)
    elm_dimensions[0] = 20
    elm_dimensions[1] = 5
    error = nefis.defelm(fp, elm_name, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    cel_name = 'Cell 1'
    cel_names_count = 2
    elm_names = ['Element 1', 'Elm 2']
    error = nefis.defcel(fp, cel_name, cel_names_count, elm_names)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_defined = 'Grp 1'
    cel_name = 'Cell 1'
    grp_count = 1
    grp_dimensions = np.arange(5).reshape(5)
    grp_dimensions[0] = 11
    grp_dimensions[1] = 0
    grp_dimensions[2] = 0
    grp_dimensions[3] = 0
    grp_dimensions[4] = 0
    grp_order = np.arange(5).reshape(5)
    grp_order[0] = 1
    grp_order[1] = 2
    grp_order[2] = 3
    grp_order[3] = 4
    grp_order[4] = 5

    error = nefis.defgrp(fp, grp_defined, cel_name, grp_count, grp_dimensions, grp_order)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    grp_defined = 'Grp 1'

    error = nefis.credat(fp, grp_name, grp_defined)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    att_name = 'Int. Attrib. 1'
    att_value = 1
    print('Putiat: >%d<' % att_value)
    error = nefis.putiat(fp, grp_name, att_name, att_value)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    att_name = 'Real Attrib. 1'
    att_value = 1.0
    print('Putrat: >%f<' % att_value)
    error = nefis.putrat(fp, grp_name, att_name, att_value)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    att_name = 'String Attrib. 1'
    att_value = 'Een string'
    print('Putsat: >%s<' % att_value)
    error = nefis.putsat(fp, grp_name, att_name, att_value)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    att_name = 'Int. Attrib. 1'
    error, att_value = nefis.getiat(fp, grp_name, att_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    print('Getiat: >%d<' % att_value)
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    att_name = 'Real Attrib. 1'
    error, att_value = nefis.getrat(fp, grp_name, att_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    print('Getrat: >%f<' % att_value)
    #-------------------------------------------------------------------------------
    grp_name = 'Group 1'
    att_name = 'String Attrib. 1'
    att_value = ' '
    error, att_value = nefis.getsat(fp, grp_name, att_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : %s' % err_string)
        print("=========")
    print('Getsat: >%s<' % att_value)
    print('        -1234567890123456-')
    #-------------------------------------------------------------------------------
    print("---------")
    error = nefis.clsnef(fp)
    print('NEFIS error code (clsnef): %d' % error)
    print("---------")


if __name__ == "__main__":
    test_nefis_attributes()
