import nefis
import numpy as np

def test_nefis_inquire():
    #-------------------------------------------------------------------------------
    error, version = nefis.getnfv()
    print('')
    print('%s' % version[14:])
    print('')
    #-------------------------------------------------------------------------------
    dat_file = 'attributes.dat'
    def_file = 'attributes.def'
    coding = ' '
    ac_type = 'c'
    fp = -1
    print('------------')
    print('Dat file: "%s"' % dat_file)
    print('Dat file: "%s"' % def_file)
    print('Coding  : "%s"' % coding)
    print('Access  : "%s"' % ac_type)
    print('------------')

    #-------------------------------------------------------------------------------
    print('---crenef---')
    error, fp = nefis.crenef(dat_file, def_file, coding, ac_type)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    #-------------------------------------------------------------------------------
    print('---defelm---')
    elm_name = 'Element 1'
    elm_type = 'character'
    elm_single_byte = 20
    elm_quantity = 'names'
    elm_unit = '[-]'
    elm_description = 'Discharge station names'
    elm_count = 1
    #elm_data = np.arange(15).reshape(5,3)
    elm_dimensions = np.arange(elm_count).reshape(elm_count)
    elm_dimensions[0] = 20
    error = nefis.defelm(fp, elm_name, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    #-------------------------------------------------------------------------------
    print('---defelm---')
    elm_name = 'Elm 2'
    elm_type = 'REAL'
    elm_single_byte = 4
    elm_quantity = 'discharge'
    elm_unit = '[m^3/s]'
    elm_description = 'First element generated by Python'
    elm_count = 2
    #elm_data = np.arange(15).reshape(5,3)
    elm_dimensions = np.arange(elm_count).reshape(elm_count)
    elm_dimensions[0] = 10
    elm_dimensions[1] = 5
    error = nefis.defelm(fp, elm_name, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    #-------------------------------------------------------------------------------
    print('---defcel---')
    cel_name = 'Cell 1'
    cel_names_count = 2
    elm_names = ['Element 1', 'Elm 2']
    error = nefis.defcel(fp, cel_name, cel_names_count, elm_names)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    #-------------------------------------------------------------------------------
    print('---defgrp---')
    grp_defined = 'Grp 1'
    cel_name = 'Cell 1'
    grp_count = 1
    grp_dimensions = np.arange(5).reshape(5)
    grp_dimensions[0] = 11
    grp_dimensions[1] = 0
    grp_dimensions[2] = 0
    grp_dimensions[3] = 0
    grp_dimensions[4] = 0
    grp_order = np.arange(5).reshape(5)
    grp_order[0] = 1
    grp_order[1] = 2
    grp_order[2] = 3
    grp_order[3] = 4
    grp_order[4] = 5

    error = nefis.defgrp(fp, grp_defined, cel_name, grp_count, grp_dimensions, grp_order)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    #-------------------------------------------------------------------------------
    print('---credat---')
    grp_name = 'Group 1'
    grp_defined = 'Grp 1'

    error = nefis.credat(fp, grp_name, grp_defined)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    #-------------------------------------------------------------------------------
    print('---putiat---')
    grp_name = 'Group 1'
    att_name = 'Int. Attrib. 1'
    att_value = 1
    error = nefis.putiat(fp, grp_name, att_name, att_value)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    print('---putrat---')
    grp_name = 'Group 1'
    att_name = 'Real Attrib. 1'
    att_value = 1.0
    error = nefis.putrat(fp, grp_name, att_name, att_value)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    print('---putsat---')
    grp_name = 'Group 1'
    att_name = 'String Attrib. 1'
    att_value = 'Een string'
    error = nefis.putsat(fp, grp_name, att_name, att_value)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print("=========")
    #-------------------------------------------------------------------------------
    print('---inqcel---')
    cel_name = 'Cell 1'
    count = 2
    error, count, elm_names = nefis.inqcel(fp, cel_name, count)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('NEFIS element names: "%s"' % elm_names)
        print('        "1234567890123456"')
        print('Name 1: "%s"' % elm_names[0:16])
        print('Name 2: "%s"' % elm_names[17:33])
    #-------------------------------------------------------------------------------
    print('---inqdat---')
    grp_name = 'Group 1'
    error, grp_defined = nefis.inqdat(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Defined: "%s"' % grp_defined)
    #-------------------------------------------------------------------------------
    print('---inqelm---')
    elm_name = 'Element 1'
    elm_dimensions = np.arange(5).reshape(5)
    elm_dimensions[0] = 0
    elm_dimensions[1] = 0
    elm_dimensions[2] = 0
    elm_dimensions[3] = 0
    elm_dimensions[4] = 0
    error, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count = nefis.inqelm(fp, elm_name, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Element    : "%s"' % elm_name)
        print('Type       : "%s"' % elm_type)
        print('Single byte: "%d"' % elm_single_byte)
        print('Quantity   : "%s"' % elm_quantity)
        print('Unit       : "%s"' % elm_unit)
        print('Description: "%s"' % elm_description)
        print('Count      : "%d"' % elm_count)
        print('Dimensions : "%s"' % elm_dimensions)
    #-------------------------------------------------------------------------------
    print('---inqelm---')
    elm_name = 'Elm 2'
    elm_dimensions = np.arange(5).reshape(5)
    elm_dimensions[0] = 0
    elm_dimensions[1] = 0
    elm_dimensions[2] = 0
    elm_dimensions[3] = 0
    elm_dimensions[4] = 0
    error, elm_type, elm_single_byte, elm_quantity, elm_unit, elm_description, elm_count = nefis.inqelm(fp, elm_name, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Element    : "%s"' % elm_name)
        print('Type       : "%s"' % elm_type)
        print('Single byte: "%d"' % elm_single_byte)
        print('Quantity   : "%s"' % elm_quantity)
        print('Unit       : "%s"' % elm_unit)
        print('Description: "%s"' % elm_description)
        print('Count      : "%d"' % elm_count)
        print('Dimensions : "%s"' % elm_dimensions)
    #-------------------------------------------------------------------------------
    print('---inqfcl---')
    count = 2
    error, cel_name, count, bytes, elm_names = nefis.inqfcl(fp, count)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Cell name  : "%s"' % cel_name)
        print('Count      : "%d"' % count)
        print('Bytes      : "%d"' % bytes)
        print('Name 1: "%s"' % elm_names[0:16])
        print('Name 2: "%s"' % elm_names[17:33])
    #-------------------------------------------------------------------------------
    print('---inqncl---')
    count = 2
    error, cel_name, count, bytes, elm_names = nefis.inqncl(fp, count)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Cell name  : "%s"' % cel_name)
        print('Count      : "%d"' % count)
        print('Bytes      : "%d"' % bytes)
        print('Name 1: "%s"' % elm_names[0:16])
        print('Name 2: "%s"' % elm_names[17:33])
    #-------------------------------------------------------------------------------
    print('---inqfel---')
    elm_dimensions = np.arange(5).reshape(5)
    elm_dimensions[0] = 0
    elm_dimensions[1] = 0
    elm_dimensions[2] = 0
    elm_dimensions[3] = 0
    elm_dimensions[4] = 0
    count = 1
    error, elm_name, elm_type, elm_quantity, elm_unit, elm_description, elm_single_byte, elm_size, elm_count = nefis.inqfel(fp, count, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Element    : "%s"' % elm_name)
        print('Type       : "%s"' % elm_type)
        print('Quantity   : "%s"' % elm_quantity)
        print('Unit       : "%s"' % elm_unit)
        print('Description: "%s"' % elm_description)
        print('Single byte: "%d"' % elm_single_byte)
        print('Size       : "%d"' % elm_size)
        print('Count      : "%d"' % elm_count)
        print('Dimensions : "%s"' % elm_dimensions)
    #-------------------------------------------------------------------------------
    print('---inqnel---')
    elm_dimensions = np.arange(5).reshape(5)
    elm_dimensions[0] = 0
    elm_dimensions[1] = 0
    elm_dimensions[2] = 0
    elm_dimensions[3] = 0
    elm_dimensions[4] = 0
    elm_count_dimensions = 1
    error, elm_name, elm_type, elm_quantity, elm_unit, elm_description, elm_single_byte, elm_size, elm_count = nefis.inqnel(fp, count, elm_dimensions)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Element    : "%s"' % elm_name)
        print('Type       : "%s"' % elm_type)
        print('Quantity   : "%s"' % elm_quantity)
        print('Unit       : "%s"' % elm_unit)
        print('Description: "%s"' % elm_description)
        print('Single byte: "%d"' % elm_single_byte)
        print('Size       : "%d"' % elm_size)
        print('Count      : "%d"' % elm_count_dimensions)
        print('Dimensions : "%s"' % elm_dimensions)
    #-------------------------------------------------------------------------------
    print('---inqfgr---')
    grp_count_dimensions = 4
    grp_dimensions = np.arange(5).reshape(5)
    grp_dimensions[0] = 0
    grp_dimensions[1] = 0
    grp_dimensions[2] = 0
    grp_dimensions[3] = 0
    grp_dimensions[4] = 0
    grp_order = np.arange(5).reshape(5)
    grp_order[0] = 0
    grp_order[1] = 0
    grp_order[2] = 0
    grp_order[3] = 0
    grp_order[4] = 0

    error, grp_defined, cel_name, grp_dim_count = nefis.inqfgr(fp, grp_count_dimensions, grp_dimensions, grp_order)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Grp defined: "%s"' % grp_defined)
        print('Cell name  : "%s"' % cel_name)
        print('Count      : "%d"' % grp_count_dimensions)
        print('Dimensions : "%s"' % grp_dimensions)
        print('Grp order  : "%s"' % grp_order)
    #-------------------------------------------------------------------------------
    print('---inqngr---')
    grp_count_dimensions = 0
    grp_dimensions = np.arange(5).reshape(5)
    grp_dimensions[0] = 0
    grp_dimensions[1] = 0
    grp_dimensions[2] = 0
    grp_dimensions[3] = 0
    grp_dimensions[4] = 0
    grp_order = np.arange(5).reshape(5)
    grp_order[0] = 0
    grp_order[1] = 0
    grp_order[2] = 0
    grp_order[3] = 0
    grp_order[4] = 0

    error, grp_defined, cel_name, grp_dim_count = nefis.inqngr(fp, grp_count_dimensions, grp_dimensions, grp_order)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Grp defined: "%s"' % grp_defined)
        print('Cell name  : "%s"' % cel_name)
        print('Count      : "%d"' % grp_count_dimensions)
        print('Dimensions : "%s"' % grp_dimensions)
        print('Grp order  : "%s"' % grp_order)
    #-------------------------------------------------------------------------------
    print('---inqfia---')
    grp_name = 'Group 1'
    error, att_name, att_value = nefis.inqfia(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Att name   : "%s"' % att_name)
        print('Att value  : "%d"' % att_value)
    #-------------------------------------------------------------------------------
    print('---inqnia---')
    grp_name = 'Group 1'
    error, att_name, att_value = nefis.inqnia(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Att name   : "%s"' % att_name)
        print('Att value  : "%d"' % att_value)
    #-------------------------------------------------------------------------------
    print('---inqfra---')
    grp_name = 'Group 1'
    error, att_name, att_value = nefis.inqfra(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Att name   : "%s"' % att_name)
        print('Att value  : "%f"' % att_value)
    #-------------------------------------------------------------------------------
    print('---inqnra---')
    grp_name = 'Group 1'
    error, att_name, att_value = nefis.inqnra(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Att name   : "%s"' % att_name)
        print('Att value  : "%f"' % att_value)
    #-------------------------------------------------------------------------------
    print('---inqfsa---')
    grp_name = 'Group 1'
    error, att_name, att_value = nefis.inqfsa(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Att name   : "%s"' % att_name)
        print('Att value  : "%s"' % att_value)
    #-------------------------------------------------------------------------------
    print('---inqnsa---')
    grp_name = 'Group 1'
    error, att_name, att_value = nefis.inqnsa(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Att name   : "%s"' % att_name)
        print('Att value  : "%s"' % att_value)
    #-------------------------------------------------------------------------------
    print('---inqfst---')
    error, grp_name, grp_defined = nefis.inqfst(fp)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Grp name   : "%s"' % grp_name)
        print('Def name   : "%s"' % grp_defined)
    #-------------------------------------------------------------------------------
    print('---inqnxt---')
    error, grp_name, grp_defined = nefis.inqnxt(fp)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Grp name   : "%s"' % grp_name)
        print('Def name   : "%s"' % grp_defined)
    #-------------------------------------------------------------------------------
    print('---inqgrp---')
    grp_defined = 'Grp 1'
    grp_count = 1
    grp_dimensions = np.arange(5).reshape(5)
    grp_dimensions[0] = 0
    grp_dimensions[1] = 0
    grp_dimensions[2] = 0
    grp_dimensions[3] = 0
    grp_dimensions[4] = 0
    grp_order = np.arange(5).reshape(5)
    grp_order[0] = 1
    grp_order[1] = 2
    grp_order[2] = 3
    grp_order[3] = 4
    grp_order[4] = 5

    error, cel_name, grp_count = nefis.inqgrp(fp, grp_defined, grp_count, grp_dimensions, grp_order)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Cell name  : "%s"' % cel_name)
        print('Count      : "%s"' % grp_count)
        print('Dimension  : "%s"' % grp_dimensions)
        print('Grp order  : "%s"' % grp_order)
    #-------------------------------------------------------------------------------
    print('---inqmxi---')
    grp_name = 'Group 1'
    error, max_index = nefis.inqmxi(fp, grp_name)
    if not error == 0:
        error, err_string = nefis.neferr()
        print('    NEFIS error string       : "%s"' % err_string)
        print('    =========')
    else:
        print('Max index  : "%s"' % max_index)

    #-------------------------------------------------------------------------------
    print('---clsnef---')
    error = nefis.clsnef(fp)
    print('NEFIS error code (clsnef): %d' % error)
    print('---------')


if __name__ == "__main__":
    test_nefis_inquire()
