/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyDatas;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.ShortString;

public enum PropertyType {
    ILLEGAL(0){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            throw new InvalidRecordException("Invalid type: 0 for record " + record);
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            throw new InvalidRecordException("Invalid type: 0 for record " + record);
        }
    }
    ,
    INT(1){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return (int)record.getPropBlock();
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forInt(record.getKeyIndexId(), record.getId(), (int)record.getPropBlock());
        }
    }
    ,
    STRING(2){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getStringFor(record);
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forStringOrArray(record.getKeyIndexId(), record.getId(), extractedValue);
        }
    }
    ,
    BOOL(3){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return this.getValue(record.getPropBlock());
        }

        private Boolean getValue(long propBlock) {
            return propBlock == 1L ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forBoolean(record.getKeyIndexId(), record.getId(), this.getValue(record.getPropBlock()));
        }
    }
    ,
    DOUBLE(4){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return Double.longBitsToDouble(record.getPropBlock());
        }

        private double getValue(long propBlock) {
            return Double.longBitsToDouble(propBlock);
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forDouble(record.getKeyIndexId(), record.getId(), this.getValue(record.getPropBlock()));
        }
    }
    ,
    FLOAT(5){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return Float.valueOf(this.getValue(record.getPropBlock()));
        }

        private float getValue(long propBlock) {
            return Float.intBitsToFloat((int)propBlock);
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forFloat(record.getKeyIndexId(), record.getId(), this.getValue(record.getPropBlock()));
        }
    }
    ,
    LONG(6){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return record.getPropBlock();
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forLong(record.getKeyIndexId(), record.getId(), record.getPropBlock());
        }
    }
    ,
    BYTE(7){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return (byte)record.getPropBlock();
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forByte(record.getKeyIndexId(), record.getId(), (byte)record.getPropBlock());
        }
    }
    ,
    CHAR(8){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return Character.valueOf((char)record.getPropBlock());
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forChar(record.getKeyIndexId(), record.getId(), (char)record.getPropBlock());
        }
    }
    ,
    ARRAY(9){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getArrayFor(record);
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forStringOrArray(record.getKeyIndexId(), record.getId(), extractedValue);
        }
    }
    ,
    SHORT(10){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return (short)record.getPropBlock();
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forShort(record.getKeyIndexId(), record.getId(), (short)record.getPropBlock());
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public Object getValue(PropertyRecord record, PropertyStore store) {
            return ShortString.decode(record.getPropBlock());
        }

        @Override
        public PropertyData newPropertyData(PropertyRecord record, Object extractedValue) {
            return PropertyDatas.forStringOrArray(record.getKeyIndexId(), record.getId(), this.getValue(record, null));
        }
    };

    private int type;

    private PropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public abstract Object getValue(PropertyRecord var1, PropertyStore var2);

    public abstract PropertyData newPropertyData(PropertyRecord var1, Object var2);

    public static PropertyType getPropertyType(int type, boolean nullOnIllegal) {
        switch (type) {
            case 0: {
                if (!nullOnIllegal) break;
                return null;
            }
            case 1: {
                return INT;
            }
            case 2: {
                return STRING;
            }
            case 3: {
                return BOOL;
            }
            case 4: {
                return DOUBLE;
            }
            case 5: {
                return FLOAT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return BYTE;
            }
            case 8: {
                return CHAR;
            }
            case 9: {
                return ARRAY;
            }
            case 10: {
                return SHORT;
            }
            case 11: {
                return SHORT_STRING;
            }
        }
        throw new InvalidRecordException("Unknown property type:" + type);
    }
}

