/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class MapUtil {
    public static <K, V> Map<K, V> genericMap(Object ... objects) {
        return MapUtil.genericMap(new HashMap(), objects);
    }

    public static <K, V> Map<K, V> genericMap(Map<K, V> targetMap, Object ... objects) {
        int i = 0;
        while (i < objects.length) {
            targetMap.put(objects[i++], objects[i++]);
        }
        return targetMap;
    }

    public static Map<String, String> stringMap(String ... strings) {
        return MapUtil.genericMap(strings);
    }

    public static Map<String, String> stringMap(Map<String, String> targetMap, String ... strings) {
        return MapUtil.genericMap(targetMap, (Object[])strings);
    }

    public static Map<String, Object> map(Object ... objects) {
        return MapUtil.genericMap(objects);
    }

    public static Map<String, Object> map(Map<String, Object> targetMap, Object ... objects) {
        return MapUtil.genericMap(targetMap, objects);
    }

    public static Map<String, String> load(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return new HashMap<Object, Object>(props);
    }

    public static Map<String, String> loadStrictly(Reader reader) {
        try {
            return MapUtil.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> load(InputStream stream) throws IOException {
        Properties props = new Properties();
        props.load(stream);
        return new HashMap<Object, Object>(props);
    }

    public static Map<String, String> loadStrictly(InputStream stream) {
        try {
            return MapUtil.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> load(File file) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            Map<String, String> map = MapUtil.load(stream);
            return map;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static Map<String, String> loadStrictly(File file) {
        try {
            return MapUtil.load(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> reversedMap = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            reversedMap.put(entry.getValue(), entry.getKey());
        }
        return reversedMap;
    }
}

