/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.index.impl.lucene.Cache;
import org.neo4j.index.impl.lucene.EntityType;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexSearcherRef;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.IndexTypeCache;
import org.neo4j.index.impl.lucene.LuceneCommand;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneTransaction;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.index.impl.lucene.MultipleBackupDeletionPolicy;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.index.IndexProviderStore;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;

public class LuceneDataSource
extends LogBackedXaDataSource {
    public static final Version LUCENE_VERSION = Version.LUCENE_31;
    public static final String DEFAULT_NAME = "lucene-index";
    public static final byte[] DEFAULT_BRANCH_ID = UTF8.encode((String)"162374");
    public static final Analyzer LOWER_CASE_WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseFilter(LUCENE_VERSION, (TokenStream)new WhitespaceTokenizer(LUCENE_VERSION, reader));
        }

        public String toString() {
            return "LOWER_CASE_WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new WhitespaceTokenizer(LUCENE_VERSION, reader);
        }

        public String toString() {
            return "WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private final Map<IndexIdentifier, Pair<IndexWriter, AtomicBoolean>> indexWriters = new HashMap<IndexIdentifier, Pair<IndexWriter, AtomicBoolean>>();
    private final Map<IndexIdentifier, IndexSearcherRef> indexSearchers = new HashMap<IndexIdentifier, IndexSearcherRef>();
    private final XaContainer xaContainer;
    private final String baseStorePath;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final IndexStore indexStore;
    final IndexProviderStore providerStore;
    private final IndexTypeCache typeCache;
    private boolean closed;
    private final Cache caching;
    EntityType nodeEntityType;
    EntityType relationshipEntityType;
    final Map<IndexIdentifier, LuceneIndex<? extends PropertyContainer>> indexes = new HashMap<IndexIdentifier, LuceneIndex<? extends PropertyContainer>>();

    public LuceneDataSource(Map<Object, Object> params) throws InstantiationException {
        super(params);
        this.caching = new Cache();
        String storeDir = (String)params.get("store_dir");
        this.baseStorePath = (String)LuceneDataSource.getStoreDir(storeDir).first();
        this.cleanWriteLocks(this.baseStorePath);
        this.indexStore = (IndexStore)params.get(IndexStore.class);
        this.providerStore = LuceneDataSource.newIndexStore(storeDir);
        this.typeCache = new IndexTypeCache(this.indexStore);
        boolean isReadOnly = false;
        if (params.containsKey("read_only")) {
            Object readOnly = params.get("read_only");
            isReadOnly = readOnly instanceof Boolean ? (Boolean)readOnly : Boolean.parseBoolean((String)readOnly);
        }
        this.nodeEntityType = new EntityType(){

            @Override
            public Document newDocument(Object entityId) {
                return IndexType.newBaseDocument((Long)entityId);
            }

            @Override
            public Class<? extends PropertyContainer> getType() {
                return Node.class;
            }
        };
        this.relationshipEntityType = new EntityType(){

            @Override
            public Document newDocument(Object entityId) {
                RelationshipId relId = (RelationshipId)entityId;
                Document doc = IndexType.newBaseDocument(relId.id);
                doc.add((Fieldable)new Field("_start_node_id_", "" + relId.startNode, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field("_end_node_id_", "" + relId.endNode, Field.Store.YES, Field.Index.NOT_ANALYZED));
                return doc;
            }

            @Override
            public Class<? extends PropertyContainer> getType() {
                return Relationship.class;
            }
        };
        LuceneCommandFactory cf = new LuceneCommandFactory();
        LuceneTransactionFactory tf = new LuceneTransactionFactory();
        this.xaContainer = XaContainer.create((XaDataSource)this, (String)(this.baseStorePath + File.separator + "lucene.log"), (XaCommandFactory)cf, (XaTransactionFactory)tf, params);
        if (!isReadOnly) {
            try {
                this.xaContainer.openLogicalLog();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to open lucene log in " + this.baseStorePath, e);
            }
            this.setKeepLogicalLogsIfSpecified((String)params.get("keep_logical_logs"), DEFAULT_NAME);
            this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
        }
    }

    IndexType getType(IndexIdentifier identifier) {
        return this.typeCache.getIndexType(identifier);
    }

    Map<String, String> getConfig(IndexIdentifier identifier) {
        return this.indexStore.get(identifier.entityType.getType(), identifier.indexName);
    }

    private void cleanWriteLocks(String directory) {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.cleanWriteLocks(file.getAbsolutePath());
                continue;
            }
            if (!file.getName().equals("write.lock")) continue;
            boolean success = file.delete();
            assert (success);
        }
    }

    static Pair<String, Boolean> getStoreDir(String dbStoreDir) {
        File dir = new File(new File(dbStoreDir), "index");
        boolean created = false;
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Unable to create directory path[" + dir.getAbsolutePath() + "] for Neo4j store.");
            }
            created = true;
        }
        return Pair.of((Object)dir.getAbsolutePath(), (Object)created);
    }

    static IndexProviderStore newIndexStore(String dbStoreDir) {
        File file = new File((String)LuceneDataSource.getStoreDir(dbStoreDir).first() + File.separator + "lucene-store.db");
        return new IndexProviderStore(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LuceneDataSource luceneDataSource = this;
        synchronized (luceneDataSource) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (IndexSearcherRef indexSearcherRef : this.indexSearchers.values()) {
                try {
                    indexSearcherRef.dispose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.indexSearchers.clear();
            for (Map.Entry entry : this.indexWriters.entrySet()) {
                try {
                    ((IndexWriter)((Pair)entry.getValue()).first()).close(true);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close index writer " + entry.getKey(), e);
                }
            }
            this.indexWriters.clear();
        }
        if (this.xaContainer != null) {
            this.xaContainer.close();
        }
        this.providerStore.close();
    }

    public XaConnection getXaConnection() {
        return new LuceneXaConnection(this.baseStorePath, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    void getReadLock() {
        this.lock.readLock().lock();
    }

    void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    void getWriteLock() {
        this.lock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    private IndexSearcherRef refreshSearcher(IndexSearcherRef searcher) {
        try {
            IndexReader reader = searcher.getSearcher().getIndexReader();
            IndexReader reopened = reader.reopen();
            if (reopened != reader) {
                IndexSearcher newSearcher = new IndexSearcher(reopened);
                searcher.detachOrClose();
                return new IndexSearcherRef(searcher.getIdentifier(), newSearcher);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static File getFileDirectory(String storeDir, byte entityType) {
        File path = new File(storeDir, "lucene");
        String extra = null;
        if (entityType == 1) {
            extra = "node";
        } else if (entityType == 2) {
            extra = "relationship";
        } else {
            throw new RuntimeException("" + entityType);
        }
        return new File(path, extra);
    }

    static File getFileDirectory(String storeDir, IndexIdentifier identifier) {
        return new File(LuceneDataSource.getFileDirectory(storeDir, identifier.entityTypeByte), identifier.indexName);
    }

    static Directory getDirectory(String storeDir, IndexIdentifier identifier) throws IOException {
        return FSDirectory.open((File)LuceneDataSource.getFileDirectory(storeDir, identifier));
    }

    static TopFieldCollector scoringCollector(Sort sorting, int n) throws IOException {
        return TopFieldCollector.create((Sort)sorting, (int)n, (boolean)false, (boolean)true, (boolean)false, (boolean)true);
    }

    synchronized IndexSearcherRef getIndexSearcher(IndexIdentifier identifier, boolean incRef) {
        try {
            IndexSearcherRef searcher = this.indexSearchers.get(identifier);
            if (searcher == null) {
                IndexWriter writer = this.getIndexWriter(identifier);
                IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)true);
                IndexSearcher indexSearcher = new IndexSearcher(reader);
                searcher = new IndexSearcherRef(identifier, indexSearcher);
                this.indexSearchers.put(identifier, searcher);
            } else {
                Pair<IndexWriter, AtomicBoolean> writer = this.indexWriters.get(identifier);
                if (writer != null && ((AtomicBoolean)writer.other()).compareAndSet(true, false) && (searcher = this.refreshSearcher(searcher)) != null) {
                    this.indexSearchers.put(identifier, searcher);
                }
            }
            if (incRef) {
                searcher.incRef();
            }
            return searcher;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    XaTransaction createTransaction(int identifier, XaLogicalLog logicalLog) {
        return new LuceneTransaction(identifier, logicalLog, this);
    }

    synchronized void invalidateIndexSearcher(IndexIdentifier identifier) {
        Pair<IndexWriter, AtomicBoolean> writer = this.indexWriters.get(identifier);
        if (writer != null) {
            ((AtomicBoolean)writer.other()).set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIndex(IndexIdentifier identifier, boolean recovery) {
        boolean removeFromIndexStore;
        this.closeWriter(identifier);
        LuceneDataSource.deleteFileOrDirectory(LuceneDataSource.getFileDirectory(this.baseStorePath, identifier));
        this.invalidateCache(identifier);
        boolean bl = removeFromIndexStore = !recovery || recovery && this.indexStore.has(identifier.entityType.getType(), identifier.indexName);
        if (removeFromIndexStore) {
            this.indexStore.remove(identifier.entityType.getType(), identifier.indexName);
        }
        this.typeCache.invalidate(identifier);
        Map<IndexIdentifier, LuceneIndex<? extends PropertyContainer>> map = this.indexes;
        synchronized (map) {
            LuceneIndex<? extends PropertyContainer> index = this.indexes.remove(identifier);
            if (index != null) {
                index.markAsDeleted();
            }
        }
    }

    private static void deleteFileOrDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    LuceneDataSource.deleteFileOrDirectory(child);
                }
            }
            file.delete();
        }
    }

    synchronized IndexWriter getIndexWriter(IndexIdentifier identifier) {
        if (this.closed) {
            throw new IllegalStateException("Index has been shut down");
        }
        Pair writer = this.indexWriters.get(identifier);
        if (writer != null) {
            return (IndexWriter)writer.first();
        }
        try {
            Directory dir = LuceneDataSource.getDirectory(this.baseStorePath, identifier);
            this.directoryExists(dir);
            IndexType type = this.getType(identifier);
            IndexWriterConfig writerConfig = new IndexWriterConfig(LUCENE_VERSION, type.analyzer);
            writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new MultipleBackupDeletionPolicy());
            Similarity similarity = type.getSimilarity();
            if (similarity != null) {
                writerConfig.setSimilarity(similarity);
            }
            IndexWriter indexWriter = new IndexWriter(dir, writerConfig);
            writer = Pair.of((Object)indexWriter, (Object)new AtomicBoolean());
            this.indexWriters.put(identifier, (Pair<IndexWriter, AtomicBoolean>)writer);
            return (IndexWriter)writer.first();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean directoryExists(Directory dir) {
        try {
            String[] files = dir.listAll();
            return files != null && files.length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    static Document findDocument(IndexType type, IndexSearcher searcher, long entityId) {
        try {
            TopDocs docs = searcher.search(type.idTermQuery(entityId), 1);
            if (docs.scoreDocs.length > 0) {
                return searcher.doc(docs.scoreDocs[0].doc);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean documentIsEmpty(Document document) {
        List fields = document.getFields();
        for (Fieldable field : fields) {
            if ("_id_".equals(field.name())) continue;
            return false;
        }
        return true;
    }

    static void remove(IndexWriter writer, Query query) {
        try {
            writer.deleteDocuments(query);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete for " + query + " using" + writer, e);
        }
    }

    private synchronized void closeWriter(IndexIdentifier identifier) {
        try {
            IndexSearcherRef searcher = this.indexSearchers.remove(identifier);
            Pair<IndexWriter, AtomicBoolean> writer = this.indexWriters.remove(identifier);
            if (searcher != null) {
                searcher.dispose();
            }
            if (writer != null) {
                ((IndexWriter)writer.first()).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close lucene writer " + identifier, e);
        }
    }

    LruCache<String, Collection<Long>> getFromCache(IndexIdentifier identifier, String key) {
        return this.caching.get(identifier, key);
    }

    void setCacheCapacity(IndexIdentifier identifier, String key, int maxNumberOfCachedEntries) {
        this.caching.setCapacity(identifier, key, maxNumberOfCachedEntries);
    }

    Integer getCacheCapacity(IndexIdentifier identifier, String key) {
        LruCache<String, Collection<Long>> cache = this.caching.get(identifier, key);
        return cache != null ? Integer.valueOf(cache.maxSize()) : null;
    }

    void invalidateCache(IndexIdentifier identifier, String key, Object value) {
        LruCache<String, Collection<Long>> cache = this.caching.get(identifier, key);
        if (cache != null) {
            cache.remove((Object)value.toString());
        }
    }

    void invalidateCache(IndexIdentifier identifier) {
        this.caching.disable(identifier);
    }

    public long getCreationTime() {
        return this.providerStore.getCreationTime();
    }

    public long getRandomIdentifier() {
        return this.providerStore.getRandomNumber();
    }

    public long getCurrentLogVersion() {
        return this.providerStore.getVersion();
    }

    public long getLastCommittedTxId() {
        return this.providerStore.getLastCommittedTx();
    }

    public void setLastCommittedTxId(long txId) {
        this.providerStore.setLastCommittedTx(txId);
    }

    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    public ClosableIterable<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        final ArrayList<SnapshotDeletionPolicy> snapshots = new ArrayList<SnapshotDeletionPolicy>();
        this.makeSureAllIndexesAreInstantiated();
        for (Map.Entry<IndexIdentifier, Pair<IndexWriter, AtomicBoolean>> writer : this.indexWriters.entrySet()) {
            SnapshotDeletionPolicy deletionPolicy = (SnapshotDeletionPolicy)((IndexWriter)writer.getValue().first()).getConfig().getIndexDeletionPolicy();
            File indexDirectory = LuceneDataSource.getFileDirectory(this.baseStorePath, writer.getKey());
            try {
                IndexCommit commit = deletionPolicy.snapshot("backup");
                for (String fileName : commit.getFileNames()) {
                    files.add(new File(indexDirectory, fileName));
                }
                snapshots.add(deletionPolicy);
            }
            catch (IllegalStateException e) {}
        }
        files.add(this.providerStore.getFile());
        return new ClosableIterable<File>(){

            public Iterator<File> iterator() {
                return files.iterator();
            }

            public void close() {
                for (SnapshotDeletionPolicy deletionPolicy : snapshots) {
                    try {
                        deletionPolicy.release("backup");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    private void makeSureAllIndexesAreInstantiated() {
        Map config;
        for (String name : this.indexStore.getNames(Node.class)) {
            config = this.indexStore.get(Node.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            this.getIndexWriter(new IndexIdentifier(1, this.nodeEntityType, name));
        }
        for (String name : this.indexStore.getNames(Relationship.class)) {
            config = this.indexStore.get(Relationship.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            this.getIndexWriter(new IndexIdentifier(2, this.relationshipEntityType, name));
        }
    }

    private class LuceneTransactionFactory
    extends XaTransactionFactory {
        private LuceneTransactionFactory() {
        }

        public XaTransaction create(int identifier) {
            return LuceneDataSource.this.createTransaction(identifier, this.getLogicalLog());
        }

        public void flushAll() {
            for (Map.Entry entry : LuceneDataSource.this.indexWriters.entrySet()) {
                try {
                    ((IndexWriter)((Pair)entry.getValue()).first()).commit();
                }
                catch (IOException e) {
                    throw new RuntimeException("unable to commit changes to " + entry.getKey(), e);
                }
            }
        }

        public long getCurrentVersion() {
            return LuceneDataSource.this.providerStore.getVersion();
        }

        public long getAndSetNewVersion() {
            return LuceneDataSource.this.providerStore.incrementVersion();
        }

        public long getLastCommittedTx() {
            return LuceneDataSource.this.providerStore.getLastCommittedTx();
        }
    }

    private class LuceneCommandFactory
    extends XaCommandFactory {
        LuceneCommandFactory() {
        }

        public XaCommand readCommand(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
            return LuceneCommand.readCommand(channel, buffer, LuceneDataSource.this);
        }
    }
}

