/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeClosure;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import java.util.Map;

public class GroupCountClosurePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, S, Map<Object, Number>> {
    private Map<Object, Number> countMap;
    private final PipeClosure valueClosure;
    private final PipeClosure keyClosure;

    public GroupCountClosurePipe(Map<Object, Number> countMap, PipeClosure keyClosure, PipeClosure valueClosure) {
        this.countMap = countMap;
        this.valueClosure = valueClosure;
        this.keyClosure = keyClosure;
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        Object key = this.getKey(s);
        this.countMap.put(key, this.getValue(key));
        return (S)s;
    }

    @Override
    public Map<Object, Number> getSideEffect() {
        return this.countMap;
    }

    @Override
    public void reset() {
        try {
            this.countMap = (Map)this.countMap.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.reset();
    }

    private Object getKey(S start) {
        if (null == this.keyClosure) {
            return start;
        }
        return this.keyClosure.compute(start);
    }

    private Number getValue(Object key) {
        Number number = this.countMap.get(key);
        if (null == number) {
            number = 0L;
        }
        if (null == this.valueClosure) {
            if (number instanceof Double) {
                return 1.0 + number.doubleValue();
            }
            if (number instanceof Long) {
                return 1L + number.longValue();
            }
            if (number instanceof Float) {
                return Float.valueOf(1.0f + number.floatValue());
            }
            return 1 + number.intValue();
        }
        return (Number)this.valueClosure.compute(number);
    }
}

