/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeClosure;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class PathClosurePipe<S>
extends AbstractPipe<S, List> {
    private final PipeClosure[] pathClosures;

    public PathClosurePipe(PipeClosure ... pathClosures) {
        this.pathClosures = pathClosures;
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        this.starts = starts;
    }

    @Override
    public List processNextStart() {
        if (this.starts instanceof Pipe) {
            this.starts.next();
            List path = ((Pipe)this.starts).getPath();
            LinkedList closedPath = new LinkedList();
            int nextClosure = 0;
            for (Object object : path) {
                closedPath.add(this.pathClosures[nextClosure].compute(object));
                nextClosure = (nextClosure + 1) % this.pathClosures.length;
            }
            return closedPath;
        }
        throw new NoSuchElementException("The start of this pipe was not a pipe");
    }
}

