/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.MetaPipe;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Pipeline<S, E>
implements Pipe<S, E>,
MetaPipe {
    private Pipe<S, ?> startPipe;
    private Pipe<?, E> endPipe;
    private List<Pipe> pipes;

    public Pipeline() {
    }

    public Pipeline(List<Pipe> pipes) {
        this.pipes = pipes;
        this.setPipes(pipes);
    }

    public Pipeline(Pipe ... pipes) {
        this(Arrays.asList(pipes));
    }

    protected void setPipes(List<Pipe> pipes) {
        this.startPipe = pipes.get(0);
        this.endPipe = pipes.get(pipes.size() - 1);
        for (int i = 1; i < pipes.size(); ++i) {
            pipes.get(i).setStarts(pipes.get(i - 1));
        }
    }

    protected void setPipes(Pipe ... pipes) {
        this.setPipes(Arrays.asList(pipes));
    }

    public void setStartPipe(Pipe<S, ?> startPipe) {
        this.startPipe = startPipe;
    }

    public void setEndPipe(Pipe<?, E> endPipe) {
        this.endPipe = endPipe;
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        this.startPipe.setStarts(starts);
    }

    @Override
    public void setStarts(Iterable<S> starts) {
        this.setStarts(starts.iterator());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.endPipe.hasNext();
    }

    @Override
    public E next() {
        return this.endPipe.next();
    }

    @Override
    public List getPath() {
        return this.endPipe.getPath();
    }

    @Override
    public void reset() {
        this.endPipe.reset();
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public String toString() {
        return this.pipes.toString();
    }

    @Override
    public List<Pipe> getPipes() {
        return this.pipes;
    }
}

