/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public abstract class LogEntry {
    static final byte CURRENT_VERSION = 1;
    public static final byte EMPTY = 0;
    public static final byte TX_START = 1;
    public static final byte TX_PREPARE = 2;
    public static final byte COMMAND = 3;
    public static final byte DONE = 4;
    public static final byte TX_1P_COMMIT = 5;
    public static final byte TX_2P_COMMIT = 6;
    private int identifier;

    LogEntry(int identifier) {
        this.identifier = identifier;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int newXidIdentifier) {
        this.identifier = newXidIdentifier;
    }

    public static class Command
    extends LogEntry {
        private final XaCommand command;

        Command(int identifier, XaCommand command) {
            super(identifier);
            this.command = command;
        }

        public XaCommand getXaCommand() {
            return this.command;
        }

        public String toString() {
            return "Command[" + this.getIdentifier() + ", " + this.command + "]";
        }
    }

    public static class TwoPhaseCommit
    extends Commit {
        TwoPhaseCommit(int identifier, long txId, int masterId) {
            super(identifier, txId, masterId);
        }

        public String toString() {
            return "2PC[" + this.getIdentifier() + ", txId=" + this.getTxId() + ", machineId=" + this.getMasterId() + "]";
        }
    }

    public static class Done
    extends LogEntry {
        Done(int identifier) {
            super(identifier);
        }

        public String toString() {
            return "Done[" + this.getIdentifier() + "]";
        }
    }

    public static class OnePhaseCommit
    extends Commit {
        OnePhaseCommit(int identifier, long txId, int masterId) {
            super(identifier, txId, masterId);
        }

        public String toString() {
            return "1PC[" + this.getIdentifier() + ", txId=" + this.getTxId() + ", masterId=" + this.getMasterId() + "]";
        }
    }

    public static abstract class Commit
    extends LogEntry {
        private final long txId;
        private final int masterId;

        Commit(int identifier, long txId, int masterId) {
            super(identifier);
            this.txId = txId;
            this.masterId = masterId;
        }

        public long getTxId() {
            return this.txId;
        }

        public int getMasterId() {
            return this.masterId;
        }
    }

    static class Prepare
    extends LogEntry {
        Prepare(int identifier) {
            super(identifier);
        }

        public String toString() {
            return "Prepare[" + this.getIdentifier() + "]";
        }
    }

    public static class Start
    extends LogEntry {
        private final Xid xid;
        private long startPosition;

        Start(Xid xid, int identifier, long startPosition) {
            super(identifier);
            this.xid = xid;
            this.startPosition = startPosition;
        }

        public Xid getXid() {
            return this.xid;
        }

        public long getStartPosition() {
            return this.startPosition;
        }

        void setStartPosition(long position) {
            this.startPosition = position;
        }

        public String toString() {
            return "Start[" + this.getIdentifier() + ", " + this.xid + "]";
        }
    }
}

