/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.event;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.event.listener.GraphChangedListener;
import com.tinkerpop.blueprints.pgm.impls.event.util.EventEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.event.util.EventVertexSequence;
import java.util.List;

public class EventIndex<T extends Element>
implements Index<T> {
    protected final Index<T> index;
    protected final List<GraphChangedListener> graphChangedListeners;

    public EventIndex(Index<T> index, List<GraphChangedListener> graphChangedListeners) {
        this.index = index;
        this.graphChangedListeners = graphChangedListeners;
    }

    @Override
    public void remove(String key, Object value, T element) {
        this.index.remove(key, value, element);
    }

    @Override
    public void put(String key, Object value, T element) {
        this.index.put(key, value, element);
    }

    @Override
    public CloseableSequence<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new EventVertexSequence(this.index.get(key, value).iterator(), this.graphChangedListeners);
        }
        return new EventEdgeSequence(this.index.get(key, value).iterator(), this.graphChangedListeners);
    }

    @Override
    public long count(String key, Object value) {
        return this.index.count(key, value);
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    @Override
    public String getIndexName() {
        return this.index.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.index.getIndexClass();
    }

    public String toString() {
        return "(event)" + this.index.toString();
    }
}

