/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.pipes;

import com.tinkerpop.gremlin.pipes.GremlinPipeline;
import com.tinkerpop.gremlin.pipes.util.Table;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.AsPipe;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TablePipe<S>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, S, Table> {
    private Table table;
    private final Closure[] closures;
    private int currentClosure;
    private final List<AsPipe> asPipes = new ArrayList<AsPipe>();
    private final boolean doClosures;

    public TablePipe(Table table, Collection<String> columnNames, GremlinPipeline pipeline, Closure ... closures) {
        this.table = table;
        this.closures = closures;
        this.doClosures = this.closures.length > 0;
        if (this.doClosures) {
            this.currentClosure = 0;
        }
        ArrayList<String> tempNames = new ArrayList<String>();
        for (AsPipe asPipe : pipeline.getAsPipes()) {
            String columnName = asPipe.getName();
            if (null != columnNames && !columnNames.contains(columnName)) continue;
            tempNames.add(columnName);
            this.asPipes.add(asPipe);
        }
        if (tempNames.size() > 0) {
            table.setColumnNames(tempNames.toArray(new String[tempNames.size()]));
        }
    }

    public Table getSideEffect() {
        return this.table;
    }

    public S processNextStart() {
        Object s = this.starts.next();
        ArrayList<Object> row = new ArrayList<Object>();
        for (AsPipe asPipe : this.asPipes) {
            if (this.doClosures) {
                row.add(this.closures[this.currentClosure++ % this.closures.length].call(asPipe.getCurrentEnd()));
                continue;
            }
            row.add(asPipe.getCurrentEnd());
        }
        this.table.addRow(row);
        return (S)s;
    }

    public void reset() {
        this.table = new Table();
        this.currentClosure = 0;
        super.reset();
    }
}

