/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.filter;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.filter.ComparisonFilterPipe;

public abstract class AbstractComparisonFilterPipe<S, T>
extends AbstractPipe<S, S>
implements ComparisonFilterPipe<S, T> {
    protected final ComparisonFilterPipe.Filter filter;

    public AbstractComparisonFilterPipe(ComparisonFilterPipe.Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean compareObjects(T leftObject, T rightObject) {
        switch (this.filter) {
            case EQUAL: {
                if (null == leftObject) {
                    return rightObject == null;
                }
                return leftObject.equals(rightObject);
            }
            case NOT_EQUAL: {
                if (null == leftObject) {
                    return rightObject != null;
                }
                return !leftObject.equals(rightObject);
            }
            case GREATER_THAN: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) == 1;
            }
            case LESS_THAN: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) == -1;
            }
            case GREATER_THAN_EQUAL: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) >= 0;
            }
            case LESS_THAN_EQUAL: {
                if (null == leftObject || rightObject == null) {
                    return false;
                }
                return ((Comparable)leftObject).compareTo(rightObject) <= 0;
            }
        }
        throw new RuntimeException("Invalid state as no valid filter was provided");
    }
}

