/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.MetaPipe;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SideEffectCapPipe<S, T>
extends AbstractPipe<S, T>
implements MetaPipe {
    private final SideEffectPipe<S, ?, T> pipeToCap;
    private boolean alive = true;

    public SideEffectCapPipe(SideEffectPipe<S, ?, T> pipeToCap) {
        this.pipeToCap = pipeToCap;
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        this.pipeToCap.setStarts(starts);
    }

    @Override
    protected T processNextStart() {
        if (this.alive) {
            while (this.pipeToCap.hasNext()) {
                this.pipeToCap.next();
            }
            this.alive = false;
            return this.pipeToCap.getSideEffect();
        }
        throw new NoSuchElementException();
    }

    @Override
    public List getPath() {
        List list = this.pipeToCap.getPath();
        list.add(this.currentEnd);
        return list;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.pipeToCap + "]";
    }

    @Override
    public List<Pipe> getPipes() {
        return Arrays.asList(this.pipeToCap);
    }

    @Override
    public void reset() {
        this.pipeToCap.reset();
        this.alive = true;
        super.reset();
    }
}

