/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.readonly;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.readonly.ReadOnlyEdge;
import com.tinkerpop.blueprints.pgm.impls.readonly.ReadOnlyVertex;
import com.tinkerpop.blueprints.pgm.impls.readonly.util.ReadOnlyEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.readonly.util.ReadOnlyVertexSequence;

public class ReadOnlyGraph
implements Graph {
    protected final Graph graph;

    public ReadOnlyGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void removeVertex(Vertex vertex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.graph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        return new ReadOnlyVertex(vertex);
    }

    @Override
    public void removeEdge(Edge edge) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new ReadOnlyEdgeSequence(this.graph.getEdges().iterator());
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.graph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new ReadOnlyEdge(edge);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new ReadOnlyVertexSequence(this.graph.getVertices().iterator());
    }

    @Override
    public Vertex addVertex(Object id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void shutdown() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    public String toString() {
        return "(readonly)" + this.graph.toString();
    }

    public Graph getRawGraph() {
        return this.graph;
    }
}

