/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.readonly;

import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.readonly.util.ReadOnlyEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.readonly.util.ReadOnlyVertexSequence;

public class ReadOnlyIndex<T extends Element>
implements Index<T> {
    protected final Index<T> index;

    public ReadOnlyIndex(Index<T> index) {
        this.index = index;
    }

    @Override
    public void remove(String key, Object value, T element) {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void put(String key, Object value, T element) {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public CloseableSequence<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new ReadOnlyVertexSequence(this.index.get(key, value).iterator());
        }
        return new ReadOnlyEdgeSequence(this.index.get(key, value).iterator());
    }

    @Override
    public long count(String key, Object value) {
        return this.index.count(key, value);
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.MANUAL;
    }

    @Override
    public String getIndexName() {
        return this.index.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.index.getIndexClass();
    }

    public String toString() {
        return "(readonly)" + this.index.toString();
    }
}

