/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerIndex;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class TinkerAutomaticIndex<T extends TinkerElement>
extends TinkerIndex<T>
implements AutomaticIndex<T>,
Serializable {
    Set<String> autoIndexKeys;

    public TinkerAutomaticIndex(String name, Class<T> indexClass, Set<String> keys) {
        super(name, indexClass);
        if (keys == null) {
            this.autoIndexKeys = null;
        } else {
            this.autoIndexKeys = new HashSet<String>();
            this.autoIndexKeys.addAll(keys);
        }
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.AUTOMATIC;
    }

    @Override
    public Set<String> getAutoIndexKeys() {
        return this.autoIndexKeys;
    }

    protected void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (this.getIndexClass().isAssignableFrom(element.getClass()) && (this.autoIndexKeys == null || this.autoIndexKeys.contains(key))) {
            if (oldValue != null) {
                this.remove(key, oldValue, element);
            }
            this.put(key, newValue, element);
        }
    }

    protected void autoRemove(String key, Object oldValue, T element) {
        if (this.getIndexClass().isAssignableFrom(element.getClass()) && (this.autoIndexKeys == null || this.autoIndexKeys.contains(key))) {
            this.remove(key, oldValue, element);
        }
    }
}

