/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.branch;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.MetaPipe;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class CopySplitPipe<S>
extends AbstractPipe<S, S>
implements MetaPipe {
    private final List<Pipe> pipes;
    private final List<CopyExpandablePipe<S>> pipeStarts = new ArrayList<CopyExpandablePipe<S>>();

    public CopySplitPipe(List<Pipe> pipes) {
        this.pipes = pipes;
        for (Pipe pipe : this.pipes) {
            CopyExpandablePipe expandable = new CopyExpandablePipe();
            expandable.setStarts(this);
            pipe.setStarts(expandable.iterator());
            this.pipeStarts.add(expandable);
        }
    }

    @Override
    public S processNextStart() {
        Object s = this.starts.next();
        for (CopyExpandablePipe copyExpandablePipe : this.pipeStarts) {
            copyExpandablePipe.add(s);
        }
        return (S)s;
    }

    @Override
    public List<Pipe> getPipes() {
        return this.pipes;
    }

    @Override
    public void reset() {
        for (Pipe pipe : this.pipes) {
            pipe.reset();
        }
        super.reset();
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.pipes + "]";
    }

    private class CopyExpandablePipe<S>
    extends AbstractPipe<S, S> {
        private final Queue<S> queue = new LinkedList<S>();

        private CopyExpandablePipe() {
        }

        @Override
        public S processNextStart() {
            while (this.queue.isEmpty()) {
                this.starts.next();
            }
            return this.queue.remove();
        }

        public void add(S s) {
            this.queue.add(s);
        }
    }
}

