/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.branch;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeClosure;
import com.tinkerpop.pipes.util.MetaPipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class LoopPipe<S>
extends AbstractPipe<S, S>
implements MetaPipe {
    private final PipeClosure<Boolean, Pipe> closure;
    private final Pipe<S, S> pipe;
    private ExpandableLoopBundleIterator<S> expando;

    public LoopPipe(Pipe<S, S> pipe, PipeClosure<Boolean, Pipe> closure) {
        this.pipe = pipe;
        this.closure = closure;
        this.closure.setPipe(this);
    }

    @Override
    protected S processNextStart() {
        Object s;
        while (true) {
            s = this.pipe.next();
            LoopBundle loopBundle = new LoopBundle(s, this.getPath(), this.getLoops());
            if (!this.closure.compute(loopBundle).booleanValue()) break;
            this.expando.add(loopBundle);
        }
        return (S)s;
    }

    @Override
    public List<Pipe> getPipes() {
        return Arrays.asList(this.pipe);
    }

    @Override
    public void setStarts(Iterator<S> iterator) {
        this.expando = new ExpandableLoopBundleIterator<S>(iterator);
        this.pipe.setStarts(this.expando);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.pipe + "]";
    }

    public int getLoops() {
        return this.expando.getCurrentLoops() + 1;
    }

    @Override
    public List getPath() {
        ArrayList path = new ArrayList();
        List currentPath = this.expando.getCurrentPath();
        if (null != currentPath) {
            path.addAll(currentPath);
        }
        path.addAll(this.pipe.getPath());
        return path;
    }

    @Override
    public void reset() {
        this.expando.clear();
        this.pipe.reset();
        super.reset();
    }

    private class ExpandableLoopBundleIterator<T>
    implements Iterator<T> {
        private final Queue<LoopBundle<T>> queue = new LinkedList<LoopBundle<T>>();
        private final Iterator<T> iterator;
        private LoopBundle<T> current;
        private int totalResets = -1;

        public ExpandableLoopBundleIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            if (this.queue.isEmpty()) {
                this.current = null;
                if (!this.iterator.hasNext()) {
                    this.incrTotalResets();
                }
                return this.iterator.next();
            }
            this.current = this.queue.remove();
            return this.current.getObject();
        }

        @Override
        public boolean hasNext() {
            if (this.queue.isEmpty() && !this.iterator.hasNext()) {
                this.incrTotalResets();
                return false;
            }
            return true;
        }

        public void add(LoopBundle<T> loopBundle) {
            this.queue.add(loopBundle);
        }

        public List getCurrentPath() {
            if (null == this.current) {
                return null;
            }
            return this.current.getPath();
        }

        public int getCurrentLoops() {
            if (null != this.current) {
                return this.current.getLoops();
            }
            if (this.totalResets == -1) {
                return 1;
            }
            return this.totalResets;
        }

        private void incrTotalResets() {
            if (this.totalResets == -1) {
                this.totalResets = 0;
            }
            ++this.totalResets;
        }

        public void clear() {
            this.totalResets = -1;
            this.current = null;
            this.queue.clear();
        }
    }

    public class LoopBundle<T> {
        private final List path;
        private final T t;
        private final int loops;

        protected LoopBundle(T t, List path, int loops) {
            this.t = t;
            this.path = path;
            this.path.remove(this.path.size() - 1);
            this.loops = loops;
        }

        public List getPath() {
            return this.path;
        }

        public int getLoops() {
            return this.loops;
        }

        public T getObject() {
            return this.t;
        }
    }
}

