/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.pipes;

import com.tinkerpop.gremlin.pipes.util.GroovyPipeClosure;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeClosure;
import com.tinkerpop.pipes.branch.LoopPipe;
import com.tinkerpop.pipes.filter.BackFilterPipe;
import com.tinkerpop.pipes.sideeffect.OptionalPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.transform.SideEffectCapPipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.Pipeline;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GremlinPipeline<S, E>
implements Pipe<S, E>,
MetaPipe {
    private Pipe<S, ?> startPipe;
    private Pipe<?, E> endPipe;
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private Iterator<S> starts;

    public List<Pipe> getPipes() {
        return this.pipes;
    }

    public void capPipe(int indexOfPipe) {
        SideEffectPipe pipe = (SideEffectPipe)this.pipes.get(indexOfPipe);
        this.pipes.remove(indexOfPipe);
        SideEffectCapPipe cap = new SideEffectCapPipe(pipe);
        this.pipes.add(indexOfPipe, (Pipe)cap);
        this.setPipes(this.pipes);
    }

    public void loopPipe(int stepsAgo, Closure closure) {
        this.addPipe((Pipe)new LoopPipe((Pipe)new Pipeline(this.getPipesStepsAgo(stepsAgo)), (PipeClosure)new GroovyPipeClosure(closure)));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public void loopPipe(String name, Closure closure) {
        this.addPipe((Pipe)new LoopPipe((Pipe)new Pipeline(this.getPipesAsAgo(name)), (PipeClosure)new GroovyPipeClosure(closure)));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public void backPipe(int stepsAgo) {
        this.addPipe((Pipe)new BackFilterPipe((Pipe)new Pipeline(this.getPipesStepsAgo(stepsAgo))));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public void backPipe(String name) {
        this.addPipe((Pipe)new BackFilterPipe((Pipe)new Pipeline(this.getPipesAsAgo(name))));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public void optionalPipe(int stepsAgo) {
        this.addPipe((Pipe)new OptionalPipe((Pipe)new Pipeline(this.getPipesStepsAgo(stepsAgo))));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public void optionalPipe(String name) {
        this.addPipe((Pipe)new OptionalPipe((Pipe)new Pipeline(this.getPipesAsAgo(name))));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public void asPipe(String name) {
        this.addPipe((Pipe)new AsPipe(name, this.getPipesStepsAgo(1).get(0)));
        if (this.pipes.size() == 1) {
            this.setStarts(this.starts);
        }
    }

    public List<AsPipe> getAsPipes() {
        return this.getAsPipes(this);
    }

    private List<AsPipe> getAsPipes(MetaPipe metaPipe) {
        ArrayList<AsPipe> asPipes = new ArrayList<AsPipe>();
        for (Pipe subPipe : metaPipe.getPipes()) {
            if (subPipe instanceof AsPipe) {
                asPipes.add((AsPipe)subPipe);
            }
            if (!(subPipe instanceof MetaPipe)) continue;
            asPipes.addAll(this.getAsPipes((MetaPipe)subPipe));
        }
        return asPipes;
    }

    private List<Pipe> getPipesStepsAgo(int stepsAgo) {
        int i;
        ArrayList<Pipe> backPipes = new ArrayList<Pipe>();
        for (i = this.pipes.size() - 1; i > this.pipes.size() - 1 - stepsAgo; --i) {
            backPipes.add(0, this.pipes.get(i));
        }
        for (i = 0; i < stepsAgo; ++i) {
            this.pipes.remove(this.pipes.size() - 1);
        }
        return backPipes;
    }

    private List<Pipe> getPipesAsAgo(String name) {
        Pipe pipe;
        int i;
        ArrayList<Pipe> asPipes = new ArrayList<Pipe>();
        for (i = this.pipes.size() - 1; !(i < 0 || (pipe = this.pipes.get(i)) instanceof AsPipe && ((AsPipe)pipe).getName().equals(name)); --i) {
            asPipes.add(0, pipe);
        }
        for (i = 0; i < asPipes.size(); ++i) {
            this.pipes.remove(this.pipes.size() - 1);
        }
        return asPipes;
    }

    public int size() {
        return this.pipes.size();
    }

    public void addPipe(Pipe pipe) {
        this.pipes.add(pipe);
        this.setPipes(this.pipes);
    }

    public void reset() {
        this.endPipe.reset();
    }

    private void setPipes(List<Pipe> pipes) {
        this.startPipe = pipes.get(0);
        this.endPipe = pipes.get(pipes.size() - 1);
        for (int i = 1; i < pipes.size(); ++i) {
            pipes.get(i).setStarts((Iterator)pipes.get(i - 1));
        }
    }

    public void setStarts(Iterator<S> starts) {
        this.starts = starts;
        this.startPipe.setStarts(starts);
    }

    public void setStarts(Iterable<S> starts) {
        this.setStarts(starts.iterator());
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.endPipe.hasNext();
    }

    public E next() {
        return (E)this.endPipe.next();
    }

    public List getPath() {
        return this.endPipe.getPath();
    }

    public Iterator<E> iterator() {
        return this;
    }

    public String toString() {
        return this.pipes.toString();
    }

    public boolean equals(Object object) {
        return object instanceof GremlinPipeline && PipeHelper.areEqual((Iterator)((Object)this), (Iterator)((Object)((GremlinPipeline)object)));
    }
}

