/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.util.IFileNameFinder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.ScriptTestAdapter;

public class AllTestSuite
extends TestSuite {
    public static final String SYSPROP_TEST_DIR = "groovy.test.dir";
    public static final String SYSPROP_TEST_PATTERN = "groovy.test.pattern";
    public static final String SYSPROP_TEST_EXCLUDES_PATTERN = "groovy.test.excludesPattern";
    private static final Logger LOG = Logger.getLogger(AllTestSuite.class.getName());
    private static final ClassLoader JAVA_LOADER = AllTestSuite.class.getClassLoader();
    private static final GroovyClassLoader GROOVY_LOADER = new GroovyClassLoader(JAVA_LOADER);
    private static final String[] EMPTY_ARGS = new String[0];
    private static IFileNameFinder finder = null;

    public static Test suite() {
        String basedir = System.getProperty(SYSPROP_TEST_DIR, "./test/");
        String pattern = System.getProperty(SYSPROP_TEST_PATTERN, "**/*Test.groovy");
        String excludesPattern = System.getProperty(SYSPROP_TEST_EXCLUDES_PATTERN, "");
        return AllTestSuite.suite(basedir, pattern);
    }

    public static Test suite(String basedir, String pattern) {
        return AllTestSuite.suite(basedir, pattern, "");
    }

    public static Test suite(String basedir, String pattern, String excludesPattern) {
        AllTestSuite suite = new AllTestSuite();
        String fileName2 = "";
        try {
            List filenames = excludesPattern.length() > 0 ? finder.getFileNames(basedir, pattern, excludesPattern) : finder.getFileNames(basedir, pattern);
            for (String fileName2 : filenames) {
                LOG.finest("trying to load " + fileName2);
                suite.loadTest(fileName2);
            }
        }
        catch (CompilationFailedException e1) {
            e1.printStackTrace();
            throw new RuntimeException("CompilationFailedException when loading " + fileName2, e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("IOException when loading " + fileName2, e2);
        }
        return suite;
    }

    protected void loadTest(String fileName) throws CompilationFailedException, IOException {
        Class type = this.compile(fileName);
        if (!Test.class.isAssignableFrom(type) && Script.class.isAssignableFrom(type)) {
            this.addTest(new ScriptTestAdapter(type, EMPTY_ARGS));
        } else {
            this.addTestSuite(type);
        }
    }

    protected Class compile(String fileName) throws CompilationFailedException, IOException {
        return GROOVY_LOADER.parseClass(new File(fileName));
    }

    static {
        try {
            Class<?> finderClass = Class.forName("groovy.util.FileNameFinder");
            finder = (IFileNameFinder)finderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find and instantiate class FileNameFinder", e);
        }
    }
}

