/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.readonly;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.IndexableGraph;
import com.tinkerpop.blueprints.pgm.impls.readonly.ReadOnlyAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.readonly.ReadOnlyGraph;
import com.tinkerpop.blueprints.pgm.impls.readonly.ReadOnlyIndex;
import com.tinkerpop.blueprints.pgm.impls.readonly.util.ReadOnlyIndexSequence;
import java.util.Set;

public class ReadOnlyIndexableGraph
extends ReadOnlyGraph
implements IndexableGraph {
    public ReadOnlyIndexableGraph(IndexableGraph graph) {
        super(graph);
    }

    @Override
    public void dropIndex(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public <T extends Element> Index<T> createManualIndex(String indexName, Class<T> indexClass) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public <T extends Element> AutomaticIndex<T> createAutomaticIndex(String indexName, Class<T> indexClass, Set<String> autoIndexKeys) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        Index<T> index = ((IndexableGraph)this.graph).getIndex(indexName, indexClass);
        if (index.getIndexType().equals((Object)Index.Type.MANUAL)) {
            return new ReadOnlyIndex<T>(index);
        }
        return new ReadOnlyAutomaticIndex((AutomaticIndex)index);
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        return new ReadOnlyIndexSequence(((IndexableGraph)this.graph).getIndices().iterator());
    }

    @Override
    public IndexableGraph getRawGraph() {
        return (IndexableGraph)this.graph;
    }
}

