/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.IndexableGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerEdge;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerIndex;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerVertex;
import com.tinkerpop.blueprints.pgm.util.AutomaticIndexHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TinkerGraph
implements IndexableGraph,
Serializable {
    private Long currentId = 0L;
    protected Map<String, Vertex> vertices = new HashMap<String, Vertex>();
    protected Map<String, Edge> edges = new HashMap<String, Edge>();
    protected Map<String, TinkerIndex> indices = new HashMap<String, TinkerIndex>();
    protected Map<String, TinkerAutomaticIndex> autoIndices = new HashMap<String, TinkerAutomaticIndex>();
    private final String directory;
    private static final String GRAPH_FILE = "/tinkergraph.dat";

    public TinkerGraph(String directory) {
        this.directory = directory;
        try {
            File file = new File(directory);
            if (!file.exists()) {
                file.mkdir();
                this.createAutomaticIndex("vertices", TinkerVertex.class, null);
                this.createAutomaticIndex("edges", TinkerEdge.class, null);
            } else {
                ObjectInputStream input = new ObjectInputStream(new FileInputStream(directory + GRAPH_FILE));
                TinkerGraph temp = (TinkerGraph)input.readObject();
                input.close();
                this.currentId = temp.currentId;
                this.vertices = temp.vertices;
                this.edges = temp.edges;
                this.indices = temp.indices;
                this.autoIndices = temp.autoIndices;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public TinkerGraph() {
        this.directory = null;
        this.createAutomaticIndex("vertices", TinkerVertex.class, null);
        this.createAutomaticIndex("edges", TinkerEdge.class, null);
    }

    protected Iterable<TinkerAutomaticIndex> getAutoIndices() {
        return this.autoIndices.values();
    }

    protected Iterable<TinkerIndex> getManualIndices() {
        HashSet<TinkerIndex> indices = new HashSet<TinkerIndex>(this.indices.values());
        indices.removeAll(this.autoIndices.values());
        return indices;
    }

    @Override
    public <T extends Element> AutomaticIndex<T> createAutomaticIndex(String indexName, Class<T> indexClass, Set<String> keys) {
        if (this.indices.containsKey(indexName)) {
            throw new RuntimeException("Index already exists: " + indexName);
        }
        TinkerAutomaticIndex<T> index = new TinkerAutomaticIndex<T>(indexName, indexClass, keys);
        this.autoIndices.put(index.getIndexName(), index);
        this.indices.put(index.getIndexName(), index);
        return index;
    }

    @Override
    public <T extends Element> Index<T> createManualIndex(String indexName, Class<T> indexClass) {
        if (this.indices.containsKey(indexName)) {
            throw new RuntimeException("Index already exists: " + indexName);
        }
        TinkerIndex<T> index = new TinkerIndex<T>(indexName, indexClass);
        this.indices.put(index.getIndexName(), index);
        return index;
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        Index index = this.indices.get(indexName);
        if (null == index) {
            return null;
        }
        if (!indexClass.isAssignableFrom(index.getIndexClass())) {
            throw new RuntimeException(indexClass + " is not assignable from " + index.getIndexClass());
        }
        return index;
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        ArrayList<Index<? extends Element>> list = new ArrayList<Index<? extends Element>>();
        for (TinkerIndex index : this.indices.values()) {
            list.add(index);
        }
        return list;
    }

    @Override
    public void dropIndex(String indexName) {
        this.indices.remove(indexName);
        this.autoIndices.remove(indexName);
    }

    @Override
    public Vertex addVertex(Object id) {
        Vertex vertex;
        String idString = null;
        if (null != id) {
            idString = id.toString();
            vertex = this.vertices.get(idString);
            if (null != vertex) {
                throw new RuntimeException("Vertex with id " + idString + " already exists");
            }
        } else {
            boolean done = false;
            while (!done) {
                idString = this.getNextId();
                vertex = this.vertices.get(idString);
                if (null != vertex) continue;
                done = true;
            }
        }
        vertex = new TinkerVertex(idString, this);
        this.vertices.put(vertex.getId().toString(), vertex);
        return vertex;
    }

    @Override
    public Vertex getVertex(Object id) {
        if (null == id) {
            return null;
        }
        String idString = id.toString();
        return this.vertices.get(idString);
    }

    @Override
    public Edge getEdge(Object id) {
        if (null == id) {
            return null;
        }
        String idString = id.toString();
        return this.edges.get(idString);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new LinkedList<Vertex>(this.vertices.values());
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new LinkedList<Edge>(this.edges.values());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        HashSet<Edge> toRemove = new HashSet<Edge>();
        for (Edge edge : vertex.getInEdges(new String[0])) {
            toRemove.add(edge);
        }
        for (Edge edge : vertex.getOutEdges(new String[0])) {
            toRemove.add(edge);
        }
        for (Edge edge : toRemove) {
            this.removeEdge(edge);
        }
        AutomaticIndexHelper.removeElement(this, (Element)vertex);
        for (TinkerIndex index : this.getManualIndices()) {
            if (!Vertex.class.isAssignableFrom(index.getIndexClass())) continue;
            TinkerIndex idx = index;
            idx.removeElement((TinkerVertex)vertex);
        }
        this.vertices.remove(vertex.getId().toString());
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Edge edge;
        String idString = null;
        if (null != id) {
            idString = id.toString();
            edge = this.edges.get(idString);
            if (null != edge) {
                throw new RuntimeException("Edge with id " + id + " already exists");
            }
        } else {
            boolean done = false;
            while (!done) {
                idString = this.getNextId();
                edge = this.edges.get(idString);
                if (null != edge) continue;
                done = true;
            }
        }
        edge = new TinkerEdge(idString, outVertex, inVertex, label, this);
        this.edges.put(edge.getId().toString(), edge);
        TinkerVertex out = (TinkerVertex)outVertex;
        TinkerVertex in = (TinkerVertex)inVertex;
        out.outEdges.add(edge);
        in.inEdges.add(edge);
        return edge;
    }

    @Override
    public void removeEdge(Edge edge) {
        TinkerVertex outVertex = (TinkerVertex)edge.getOutVertex();
        TinkerVertex inVertex = (TinkerVertex)edge.getInVertex();
        if (null != outVertex && null != outVertex.outEdges) {
            outVertex.outEdges.remove(edge);
        }
        if (null != inVertex && null != inVertex.inEdges) {
            inVertex.inEdges.remove(edge);
        }
        AutomaticIndexHelper.removeElement(this, (Element)edge);
        for (TinkerIndex index : this.getManualIndices()) {
            if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
            TinkerIndex idx = index;
            idx.removeElement((TinkerEdge)edge);
        }
        this.edges.remove(edge.getId().toString());
    }

    public String toString() {
        return "tinkergraph[vertices:" + this.vertices.size() + " edges:" + this.edges.size() + "]";
    }

    @Override
    public void clear() {
        this.vertices.clear();
        this.edges.clear();
        this.indices.clear();
        this.autoIndices.clear();
        this.currentId = 0L;
        this.createAutomaticIndex("vertices", TinkerVertex.class, null);
        this.createAutomaticIndex("edges", TinkerEdge.class, null);
    }

    @Override
    public void shutdown() {
        if (null != this.directory) {
            try {
                File file = new File(this.directory + GRAPH_FILE);
                if (file.exists()) {
                    file.delete();
                }
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.directory + GRAPH_FILE));
                out.writeObject(this);
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private String getNextId() {
        String idString;
        do {
            idString = this.currentId.toString();
            TinkerGraph tinkerGraph = this;
            Long l = tinkerGraph.currentId;
            Long l2 = tinkerGraph.currentId = Long.valueOf(tinkerGraph.currentId + 1L);
        } while (null != this.vertices.get(idString) && null != this.edges.get(idString) && this.currentId != Long.MAX_VALUE);
        return idString;
    }

    public TinkerGraph getRawGraph() {
        return this;
    }
}

