/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util;

import com.tinkerpop.blueprints.pgm.TransactionalGraph;

public class TransactionalGraphHelper {
    public static CommitManager createCommitManager(TransactionalGraph graph, int bufferSize) {
        return new CommitManager(graph, bufferSize);
    }

    public static class CommitManager {
        private final TransactionalGraph graph;
        private final TransactionalGraph.Mode startMode;
        private final int bufferSize;
        private long counter = 0L;

        public CommitManager(TransactionalGraph graph, int bufferSize) {
            this.graph = graph;
            this.startMode = graph.getTransactionMode();
            this.bufferSize = bufferSize;
            this.graph.setTransactionMode(TransactionalGraph.Mode.MANUAL);
            this.graph.startTransaction();
        }

        public void incrCounter() {
            ++this.counter;
            if (this.counter % (long)this.bufferSize == 0L) {
                this.graph.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
                this.graph.startTransaction();
            }
        }

        public long getCounter() {
            return this.counter;
        }

        public boolean atCommit() {
            return this.counter % (long)this.bufferSize == 0L;
        }

        public void close() {
            this.graph.stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            this.graph.setTransactionMode(this.startMode);
        }

        public long getCommitCount() {
            return this.counter / (long)this.bufferSize;
        }
    }
}

