/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.filter;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.filter.ComparisonFilterPipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import java.util.Collection;

public class CollectionFilterPipe<S>
extends AbstractPipe<S, S>
implements FilterPipe<S>,
ComparisonFilterPipe<S, S> {
    private final Collection<S> storedCollection;
    private final ComparisonFilterPipe.Filter filter;

    public CollectionFilterPipe(Collection<S> storedCollection, ComparisonFilterPipe.Filter filter) {
        this.storedCollection = storedCollection;
        if (filter != ComparisonFilterPipe.Filter.NOT_EQUAL && filter != ComparisonFilterPipe.Filter.EQUAL) {
            throw new IllegalArgumentException("The only legal filters are equals and not equals");
        }
        this.filter = filter;
    }

    @Override
    public boolean compareObjects(S leftObject, S rightObject) {
        if (this.filter == ComparisonFilterPipe.Filter.NOT_EQUAL) {
            return !this.storedCollection.contains(rightObject);
        }
        return this.storedCollection.contains(rightObject);
    }

    @Override
    protected S processNextStart() {
        Object s;
        while (!this.compareObjects((S)null, (S)(s = this.starts.next()))) {
        }
        return (S)s;
    }
}

